package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.{
  Description,
  RepositoryName,
  AccountId,
  DomainName
}
import scala.jdk.CollectionConverters._
final case class UpdateRepositoryRequest(
    domain: DomainName,
    domainOwner: Option[AccountId] = None,
    repository: RepositoryName,
    description: Option[Description] = None,
    upstreams: Option[Iterable[zio.aws.codeartifact.model.UpstreamRepository]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.UpdateRepositoryRequest = {
    import UpdateRepositoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.UpdateRepositoryRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .repository(RepositoryName.unwrap(repository): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        upstreams.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.upstreams)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.UpdateRepositoryRequest.ReadOnly =
    zio.aws.codeartifact.model.UpdateRepositoryRequest.wrap(buildAwsValue())
}
object UpdateRepositoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.UpdateRepositoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.UpdateRepositoryRequest =
      zio.aws.codeartifact.model.UpdateRepositoryRequest(
        domain,
        domainOwner.map(value => value),
        repository,
        description.map(value => value),
        upstreams.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def domain: DomainName
    def domainOwner: Option[AccountId]
    def repository: RepositoryName
    def description: Option[Description]
    def upstreams
        : Option[List[zio.aws.codeartifact.model.UpstreamRepository.ReadOnly]]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
    def getRepository: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repository)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getUpstreams: ZIO[Any, AwsError, List[
      zio.aws.codeartifact.model.UpstreamRepository.ReadOnly
    ]] = AwsError.unwrapOptionField("upstreams", upstreams)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.UpdateRepositoryRequest
  ) extends zio.aws.codeartifact.model.UpdateRepositoryRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val domainOwner: Option[AccountId] = scala
      .Option(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val repository: RepositoryName =
      zio.aws.codeartifact.model.primitives.RepositoryName(impl.repository())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.codeartifact.model.primitives.Description(value))
    override val upstreams
        : Option[List[zio.aws.codeartifact.model.UpstreamRepository.ReadOnly]] =
      scala
        .Option(impl.upstreams())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codeartifact.model.UpstreamRepository.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.UpdateRepositoryRequest
  ): zio.aws.codeartifact.model.UpdateRepositoryRequest.ReadOnly = new Wrapper(
    impl
  )
}
