package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DisassociateExternalConnectionResponse(
    repository: Option[zio.aws.codeartifact.model.RepositoryDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.DisassociateExternalConnectionResponse = {
    import DisassociateExternalConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.DisassociateExternalConnectionResponse
      .builder()
      .optionallyWith(repository.map(value => value.buildAwsValue()))(
        _.repository
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.DisassociateExternalConnectionResponse.ReadOnly =
    zio.aws.codeartifact.model.DisassociateExternalConnectionResponse
      .wrap(buildAwsValue())
}
object DisassociateExternalConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.DisassociateExternalConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeartifact.model.DisassociateExternalConnectionResponse =
      zio.aws.codeartifact.model.DisassociateExternalConnectionResponse(
        repository.map(value => value.asEditable)
      )
    def repository
        : Option[zio.aws.codeartifact.model.RepositoryDescription.ReadOnly]
    def getRepository: ZIO[
      Any,
      AwsError,
      zio.aws.codeartifact.model.RepositoryDescription.ReadOnly
    ] = AwsError.unwrapOptionField("repository", repository)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.DisassociateExternalConnectionResponse
  ) extends zio.aws.codeartifact.model.DisassociateExternalConnectionResponse.ReadOnly {
    override val repository
        : Option[zio.aws.codeartifact.model.RepositoryDescription.ReadOnly] =
      scala
        .Option(impl.repository())
        .map(value =>
          zio.aws.codeartifact.model.RepositoryDescription.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.DisassociateExternalConnectionResponse
  ): zio.aws.codeartifact.model.DisassociateExternalConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
