package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.RepositoryName
import scala.jdk.CollectionConverters._
final case class UpstreamRepositoryInfo(
    repositoryName: Option[RepositoryName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.UpstreamRepositoryInfo = {
    import UpstreamRepositoryInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.UpstreamRepositoryInfo
      .builder()
      .optionallyWith(
        repositoryName.map(value =>
          RepositoryName.unwrap(value): java.lang.String
        )
      )(_.repositoryName)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.UpstreamRepositoryInfo.ReadOnly =
    zio.aws.codeartifact.model.UpstreamRepositoryInfo.wrap(buildAwsValue())
}
object UpstreamRepositoryInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.UpstreamRepositoryInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.UpstreamRepositoryInfo =
      zio.aws.codeartifact.model
        .UpstreamRepositoryInfo(repositoryName.map(value => value))
    def repositoryName: Option[RepositoryName]
    def getRepositoryName: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.UpstreamRepositoryInfo
  ) extends zio.aws.codeartifact.model.UpstreamRepositoryInfo.ReadOnly {
    override val repositoryName: Option[RepositoryName] = scala
      .Option(impl.repositoryName())
      .map(value => zio.aws.codeartifact.model.primitives.RepositoryName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.UpstreamRepositoryInfo
  ): zio.aws.codeartifact.model.UpstreamRepositoryInfo.ReadOnly = new Wrapper(
    impl
  )
}
