package zio.aws.cloudsearchdomain
import zio.aws.cloudsearchdomain.model.{
  UploadDocumentsRequest,
  SuggestRequest,
  SearchRequest
}
import zio.aws.cloudsearchdomain.model.SearchResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.cloudsearchdomain.CloudSearchDomainAsyncClient
object CloudSearchDomainMock extends Mock[CloudSearchDomain] {
  object Search extends Effect[SearchRequest, AwsError, ReadOnly]
  object Suggest
      extends Effect[
        SuggestRequest,
        AwsError,
        zio.aws.cloudsearchdomain.model.SuggestResponse.ReadOnly
      ]
  object UploadDocuments
      extends Effect[
        Tuple2[UploadDocumentsRequest, ZStream[Any, AwsError, Byte]],
        AwsError,
        zio.aws.cloudsearchdomain.model.UploadDocumentsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, CloudSearchDomain] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, CloudSearchDomain] { rts =>
        zio.ZIO.succeed {
          new CloudSearchDomain {
            val api: CloudSearchDomainAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): CloudSearchDomain = this
            def search(request: SearchRequest): IO[AwsError, ReadOnly] =
              proxy(Search, request)
            def suggest(request: SuggestRequest): IO[
              AwsError,
              zio.aws.cloudsearchdomain.model.SuggestResponse.ReadOnly
            ] = proxy(Suggest, request)
            def uploadDocuments(
                request: UploadDocumentsRequest,
                body: ZStream[Any, AwsError, Byte]
            ): IO[
              AwsError,
              zio.aws.cloudsearchdomain.model.UploadDocumentsResponse.ReadOnly
            ] = proxy(UploadDocuments, request, body)
          }
        }
      }
    }
  }
}
