package zio.aws.cloudsearchdomain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SuggestStatus(
    timems: Optional[Long] = Optional.Absent,
    rid: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudsearchdomain.model.SuggestStatus = {
    import SuggestStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudsearchdomain.model.SuggestStatus
      .builder()
      .optionallyWith(timems.map(value => value: java.lang.Long))(_.timems)
      .optionallyWith(rid.map(value => value: java.lang.String))(_.rid)
      .build()
  }
  def asReadOnly: zio.aws.cloudsearchdomain.model.SuggestStatus.ReadOnly =
    zio.aws.cloudsearchdomain.model.SuggestStatus.wrap(buildAwsValue())
}
object SuggestStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudsearchdomain.model.SuggestStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudsearchdomain.model.SuggestStatus =
      zio.aws.cloudsearchdomain.model
        .SuggestStatus(timems.map(value => value), rid.map(value => value))
    def timems: Optional[Long]
    def rid: Optional[String]
    def getTimems: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("timems", timems)
    def getRid: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("rid", rid)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.SuggestStatus
  ) extends zio.aws.cloudsearchdomain.model.SuggestStatus.ReadOnly {
    override val timems: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.timems())
      .map(value => value: Long)
    override val rid: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.rid())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.SuggestStatus
  ): zio.aws.cloudsearchdomain.model.SuggestStatus.ReadOnly = new Wrapper(impl)
}
