package zio.aws.cloudsearchdomain.model
import zio.ZIO
import zio.aws.cloudsearchdomain.model.primitives.{
  Cursor,
  Sort,
  Highlight,
  Stat,
  Partial,
  Facet,
  FilterQuery,
  QueryOptions,
  Start,
  Query,
  Size,
  Expr,
  Return
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SearchRequest(
    cursor: Optional[Cursor] = Optional.Absent,
    expr: Optional[Expr] = Optional.Absent,
    facet: Optional[Facet] = Optional.Absent,
    filterQuery: Optional[FilterQuery] = Optional.Absent,
    highlight: Optional[Highlight] = Optional.Absent,
    partial: Optional[Partial] = Optional.Absent,
    query: Query,
    queryOptions: Optional[QueryOptions] = Optional.Absent,
    queryParser: Optional[zio.aws.cloudsearchdomain.model.QueryParser] =
      Optional.Absent,
    returnValues: Optional[Return] = Optional.Absent,
    size: Optional[Size] = Optional.Absent,
    sort: Optional[Sort] = Optional.Absent,
    start: Optional[Start] = Optional.Absent,
    stats: Optional[Stat] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudsearchdomain.model.SearchRequest = {
    import SearchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudsearchdomain.model.SearchRequest
      .builder()
      .optionallyWith(
        cursor.map(value => Cursor.unwrap(value): java.lang.String)
      )(_.cursor)
      .optionallyWith(expr.map(value => Expr.unwrap(value): java.lang.String))(
        _.expr
      )
      .optionallyWith(
        facet.map(value => Facet.unwrap(value): java.lang.String)
      )(_.facet)
      .optionallyWith(
        filterQuery.map(value => FilterQuery.unwrap(value): java.lang.String)
      )(_.filterQuery)
      .optionallyWith(
        highlight.map(value => Highlight.unwrap(value): java.lang.String)
      )(_.highlight)
      .optionallyWith(
        partial.map(value => Partial.unwrap(value): java.lang.Boolean)
      )(_.partial)
      .query(Query.unwrap(query): java.lang.String)
      .optionallyWith(
        queryOptions.map(value => QueryOptions.unwrap(value): java.lang.String)
      )(_.queryOptions)
      .optionallyWith(queryParser.map(value => value.unwrap))(_.queryParser)
      .optionallyWith(
        returnValues.map(value => Return.unwrap(value): java.lang.String)
      )(_.returnValues)
      .optionallyWith(size.map(value => Size.unwrap(value): java.lang.Long))(
        _.size
      )
      .optionallyWith(sort.map(value => Sort.unwrap(value): java.lang.String))(
        _.sort
      )
      .optionallyWith(start.map(value => Start.unwrap(value): java.lang.Long))(
        _.start
      )
      .optionallyWith(stats.map(value => Stat.unwrap(value): java.lang.String))(
        _.stats
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudsearchdomain.model.SearchRequest.ReadOnly =
    zio.aws.cloudsearchdomain.model.SearchRequest.wrap(buildAwsValue())
}
object SearchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudsearchdomain.model.SearchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudsearchdomain.model.SearchRequest =
      zio.aws.cloudsearchdomain.model.SearchRequest(
        cursor.map(value => value),
        expr.map(value => value),
        facet.map(value => value),
        filterQuery.map(value => value),
        highlight.map(value => value),
        partial.map(value => value),
        query,
        queryOptions.map(value => value),
        queryParser.map(value => value),
        returnValues.map(value => value),
        size.map(value => value),
        sort.map(value => value),
        start.map(value => value),
        stats.map(value => value)
      )
    def cursor: Optional[Cursor]
    def expr: Optional[Expr]
    def facet: Optional[Facet]
    def filterQuery: Optional[FilterQuery]
    def highlight: Optional[Highlight]
    def partial: Optional[Partial]
    def query: Query
    def queryOptions: Optional[QueryOptions]
    def queryParser: Optional[zio.aws.cloudsearchdomain.model.QueryParser]
    def returnValues: Optional[Return]
    def size: Optional[Size]
    def sort: Optional[Sort]
    def start: Optional[Start]
    def stats: Optional[Stat]
    def getCursor: ZIO[Any, AwsError, Cursor] =
      AwsError.unwrapOptionField("cursor", cursor)
    def getExpr: ZIO[Any, AwsError, Expr] =
      AwsError.unwrapOptionField("expr", expr)
    def getFacet: ZIO[Any, AwsError, Facet] =
      AwsError.unwrapOptionField("facet", facet)
    def getFilterQuery: ZIO[Any, AwsError, FilterQuery] =
      AwsError.unwrapOptionField("filterQuery", filterQuery)
    def getHighlight: ZIO[Any, AwsError, Highlight] =
      AwsError.unwrapOptionField("highlight", highlight)
    def getPartial: ZIO[Any, AwsError, Partial] =
      AwsError.unwrapOptionField("partial", partial)
    def getQuery: ZIO[Any, Nothing, Query] = ZIO.succeed(query)
    def getQueryOptions: ZIO[Any, AwsError, QueryOptions] =
      AwsError.unwrapOptionField("queryOptions", queryOptions)
    def getQueryParser
        : ZIO[Any, AwsError, zio.aws.cloudsearchdomain.model.QueryParser] =
      AwsError.unwrapOptionField("queryParser", queryParser)
    def getReturnValues: ZIO[Any, AwsError, Return] =
      AwsError.unwrapOptionField("returnValues", returnValues)
    def getSize: ZIO[Any, AwsError, Size] =
      AwsError.unwrapOptionField("size", size)
    def getSort: ZIO[Any, AwsError, Sort] =
      AwsError.unwrapOptionField("sort", sort)
    def getStart: ZIO[Any, AwsError, Start] =
      AwsError.unwrapOptionField("start", start)
    def getStats: ZIO[Any, AwsError, Stat] =
      AwsError.unwrapOptionField("stats", stats)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.SearchRequest
  ) extends zio.aws.cloudsearchdomain.model.SearchRequest.ReadOnly {
    override val cursor: Optional[Cursor] = zio.aws.core.internal
      .optionalFromNullable(impl.cursor())
      .map(value => zio.aws.cloudsearchdomain.model.primitives.Cursor(value))
    override val expr: Optional[Expr] = zio.aws.core.internal
      .optionalFromNullable(impl.expr())
      .map(value => zio.aws.cloudsearchdomain.model.primitives.Expr(value))
    override val facet: Optional[Facet] = zio.aws.core.internal
      .optionalFromNullable(impl.facet())
      .map(value => zio.aws.cloudsearchdomain.model.primitives.Facet(value))
    override val filterQuery: Optional[FilterQuery] = zio.aws.core.internal
      .optionalFromNullable(impl.filterQuery())
      .map(value =>
        zio.aws.cloudsearchdomain.model.primitives.FilterQuery(value)
      )
    override val highlight: Optional[Highlight] = zio.aws.core.internal
      .optionalFromNullable(impl.highlight())
      .map(value => zio.aws.cloudsearchdomain.model.primitives.Highlight(value))
    override val partial: Optional[Partial] = zio.aws.core.internal
      .optionalFromNullable(impl.partial())
      .map(value => zio.aws.cloudsearchdomain.model.primitives.Partial(value))
    override val query: Query =
      zio.aws.cloudsearchdomain.model.primitives.Query(impl.query())
    override val queryOptions: Optional[QueryOptions] = zio.aws.core.internal
      .optionalFromNullable(impl.queryOptions())
      .map(value =>
        zio.aws.cloudsearchdomain.model.primitives.QueryOptions(value)
      )
    override val queryParser
        : Optional[zio.aws.cloudsearchdomain.model.QueryParser] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryParser())
        .map(value => zio.aws.cloudsearchdomain.model.QueryParser.wrap(value))
    override val returnValues: Optional[Return] = zio.aws.core.internal
      .optionalFromNullable(impl.returnValues())
      .map(value => zio.aws.cloudsearchdomain.model.primitives.Return(value))
    override val size: Optional[Size] = zio.aws.core.internal
      .optionalFromNullable(impl.size())
      .map(value => zio.aws.cloudsearchdomain.model.primitives.Size(value))
    override val sort: Optional[Sort] = zio.aws.core.internal
      .optionalFromNullable(impl.sort())
      .map(value => zio.aws.cloudsearchdomain.model.primitives.Sort(value))
    override val start: Optional[Start] = zio.aws.core.internal
      .optionalFromNullable(impl.start())
      .map(value => zio.aws.cloudsearchdomain.model.primitives.Start(value))
    override val stats: Optional[Stat] = zio.aws.core.internal
      .optionalFromNullable(impl.stats())
      .map(value => zio.aws.cloudsearchdomain.model.primitives.Stat(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.SearchRequest
  ): zio.aws.cloudsearchdomain.model.SearchRequest.ReadOnly = new Wrapper(impl)
}
