package zio.aws.cloudsearchdomain.model
import zio.ZIO
import zio.aws.cloudsearchdomain.model.primitives.{
  SuggestionsSize,
  Suggester,
  Query
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SuggestRequest(
    query: Query,
    suggester: Suggester,
    size: Optional[SuggestionsSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudsearchdomain.model.SuggestRequest = {
    import SuggestRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudsearchdomain.model.SuggestRequest
      .builder()
      .query(Query.unwrap(query): java.lang.String)
      .suggester(Suggester.unwrap(suggester): java.lang.String)
      .optionallyWith(
        size.map(value => SuggestionsSize.unwrap(value): java.lang.Long)
      )(_.size)
      .build()
  }
  def asReadOnly: zio.aws.cloudsearchdomain.model.SuggestRequest.ReadOnly =
    zio.aws.cloudsearchdomain.model.SuggestRequest.wrap(buildAwsValue())
}
object SuggestRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudsearchdomain.model.SuggestRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudsearchdomain.model.SuggestRequest =
      zio.aws.cloudsearchdomain.model
        .SuggestRequest(query, suggester, size.map(value => value))
    def query: Query
    def suggester: Suggester
    def size: Optional[SuggestionsSize]
    def getQuery: ZIO[Any, Nothing, Query] = ZIO.succeed(query)
    def getSuggester: ZIO[Any, Nothing, Suggester] = ZIO.succeed(suggester)
    def getSize: ZIO[Any, AwsError, SuggestionsSize] =
      AwsError.unwrapOptionField("size", size)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.SuggestRequest
  ) extends zio.aws.cloudsearchdomain.model.SuggestRequest.ReadOnly {
    override val query: Query =
      zio.aws.cloudsearchdomain.model.primitives.Query(impl.query())
    override val suggester: Suggester =
      zio.aws.cloudsearchdomain.model.primitives.Suggester(impl.suggester())
    override val size: Optional[SuggestionsSize] = zio.aws.core.internal
      .optionalFromNullable(impl.size())
      .map(value =>
        zio.aws.cloudsearchdomain.model.primitives.SuggestionsSize(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.SuggestRequest
  ): zio.aws.cloudsearchdomain.model.SuggestRequest.ReadOnly = new Wrapper(impl)
}
