package zio.aws.cloudsearchdomain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SuggestModel(
    query: Optional[String] = Optional.Absent,
    found: Optional[Long] = Optional.Absent,
    suggestions: Optional[
      Iterable[zio.aws.cloudsearchdomain.model.SuggestionMatch]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudsearchdomain.model.SuggestModel = {
    import SuggestModel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudsearchdomain.model.SuggestModel
      .builder()
      .optionallyWith(query.map(value => value: java.lang.String))(_.query)
      .optionallyWith(found.map(value => value: java.lang.Long))(_.found)
      .optionallyWith(
        suggestions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.suggestions)
      .build()
  }
  def asReadOnly: zio.aws.cloudsearchdomain.model.SuggestModel.ReadOnly =
    zio.aws.cloudsearchdomain.model.SuggestModel.wrap(buildAwsValue())
}
object SuggestModel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudsearchdomain.model.SuggestModel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudsearchdomain.model.SuggestModel =
      zio.aws.cloudsearchdomain.model.SuggestModel(
        query.map(value => value),
        found.map(value => value),
        suggestions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def query: Optional[String]
    def found: Optional[Long]
    def suggestions: Optional[
      List[zio.aws.cloudsearchdomain.model.SuggestionMatch.ReadOnly]
    ]
    def getQuery: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("query", query)
    def getFound: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("found", found)
    def getSuggestions: ZIO[Any, AwsError, List[
      zio.aws.cloudsearchdomain.model.SuggestionMatch.ReadOnly
    ]] = AwsError.unwrapOptionField("suggestions", suggestions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.SuggestModel
  ) extends zio.aws.cloudsearchdomain.model.SuggestModel.ReadOnly {
    override val query: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.query())
      .map(value => value: String)
    override val found: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.found())
      .map(value => value: Long)
    override val suggestions: Optional[
      List[zio.aws.cloudsearchdomain.model.SuggestionMatch.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.suggestions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudsearchdomain.model.SuggestionMatch.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.SuggestModel
  ): zio.aws.cloudsearchdomain.model.SuggestModel.ReadOnly = new Wrapper(impl)
}
