package zio.aws.cloudsearchdomain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SuggestionMatch(
    suggestion: Optional[String] = Optional.Absent,
    score: Optional[Long] = Optional.Absent,
    id: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudsearchdomain.model.SuggestionMatch = {
    import SuggestionMatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudsearchdomain.model.SuggestionMatch
      .builder()
      .optionallyWith(suggestion.map(value => value: java.lang.String))(
        _.suggestion
      )
      .optionallyWith(score.map(value => value: java.lang.Long))(_.score)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .build()
  }
  def asReadOnly: zio.aws.cloudsearchdomain.model.SuggestionMatch.ReadOnly =
    zio.aws.cloudsearchdomain.model.SuggestionMatch.wrap(buildAwsValue())
}
object SuggestionMatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudsearchdomain.model.SuggestionMatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudsearchdomain.model.SuggestionMatch =
      zio.aws.cloudsearchdomain.model.SuggestionMatch(
        suggestion.map(value => value),
        score.map(value => value),
        id.map(value => value)
      )
    def suggestion: Optional[String]
    def score: Optional[Long]
    def id: Optional[String]
    def getSuggestion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("suggestion", suggestion)
    def getScore: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("score", score)
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.SuggestionMatch
  ) extends zio.aws.cloudsearchdomain.model.SuggestionMatch.ReadOnly {
    override val suggestion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.suggestion())
      .map(value => value: String)
    override val score: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.score())
      .map(value => value: Long)
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.SuggestionMatch
  ): zio.aws.cloudsearchdomain.model.SuggestionMatch.ReadOnly = new Wrapper(
    impl
  )
}
