package zio.aws.cloudsearchdomain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Bucket(
    value: Optional[String] = Optional.Absent,
    count: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudsearchdomain.model.Bucket = {
    import Bucket.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudsearchdomain.model.Bucket
      .builder()
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(count.map(value => value: java.lang.Long))(_.count)
      .build()
  }
  def asReadOnly: zio.aws.cloudsearchdomain.model.Bucket.ReadOnly =
    zio.aws.cloudsearchdomain.model.Bucket.wrap(buildAwsValue())
}
object Bucket {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudsearchdomain.model.Bucket
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudsearchdomain.model.Bucket =
      zio.aws.cloudsearchdomain.model
        .Bucket(value.map(value => value), count.map(value => value))
    def value: Optional[String]
    def count: Optional[Long]
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("count", count)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.Bucket
  ) extends zio.aws.cloudsearchdomain.model.Bucket.ReadOnly {
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val count: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.Bucket
  ): zio.aws.cloudsearchdomain.model.Bucket.ReadOnly = new Wrapper(impl)
}
