package zio.aws.cloudsearchdomain.model
import zio.ZIO
import zio.aws.cloudsearchdomain.model.primitives.{Deletes, Adds}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UploadDocumentsResponse(
    status: Optional[String] = Optional.Absent,
    adds: Optional[Adds] = Optional.Absent,
    deletes: Optional[Deletes] = Optional.Absent,
    warnings: Optional[
      Iterable[zio.aws.cloudsearchdomain.model.DocumentServiceWarning]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudsearchdomain.model.UploadDocumentsResponse = {
    import UploadDocumentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudsearchdomain.model.UploadDocumentsResponse
      .builder()
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(adds.map(value => Adds.unwrap(value): java.lang.Long))(
        _.adds
      )
      .optionallyWith(
        deletes.map(value => Deletes.unwrap(value): java.lang.Long)
      )(_.deletes)
      .optionallyWith(
        warnings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.warnings)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudsearchdomain.model.UploadDocumentsResponse.ReadOnly =
    zio.aws.cloudsearchdomain.model.UploadDocumentsResponse
      .wrap(buildAwsValue())
}
object UploadDocumentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudsearchdomain.model.UploadDocumentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudsearchdomain.model.UploadDocumentsResponse =
      zio.aws.cloudsearchdomain.model.UploadDocumentsResponse(
        status.map(value => value),
        adds.map(value => value),
        deletes.map(value => value),
        warnings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def status: Optional[String]
    def adds: Optional[Adds]
    def deletes: Optional[Deletes]
    def warnings: Optional[
      List[zio.aws.cloudsearchdomain.model.DocumentServiceWarning.ReadOnly]
    ]
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getAdds: ZIO[Any, AwsError, Adds] =
      AwsError.unwrapOptionField("adds", adds)
    def getDeletes: ZIO[Any, AwsError, Deletes] =
      AwsError.unwrapOptionField("deletes", deletes)
    def getWarnings: ZIO[Any, AwsError, List[
      zio.aws.cloudsearchdomain.model.DocumentServiceWarning.ReadOnly
    ]] = AwsError.unwrapOptionField("warnings", warnings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.UploadDocumentsResponse
  ) extends zio.aws.cloudsearchdomain.model.UploadDocumentsResponse.ReadOnly {
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val adds: Optional[Adds] = zio.aws.core.internal
      .optionalFromNullable(impl.adds())
      .map(value => zio.aws.cloudsearchdomain.model.primitives.Adds(value))
    override val deletes: Optional[Deletes] = zio.aws.core.internal
      .optionalFromNullable(impl.deletes())
      .map(value => zio.aws.cloudsearchdomain.model.primitives.Deletes(value))
    override val warnings: Optional[
      List[zio.aws.cloudsearchdomain.model.DocumentServiceWarning.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.warnings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudsearchdomain.model.DocumentServiceWarning.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.UploadDocumentsResponse
  ): zio.aws.cloudsearchdomain.model.UploadDocumentsResponse.ReadOnly =
    new Wrapper(impl)
}
