package zio.aws.cloudsearchdomain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SearchResponse(
    status: Optional[zio.aws.cloudsearchdomain.model.SearchStatus] =
      Optional.Absent,
    hits: Optional[zio.aws.cloudsearchdomain.model.Hits] = Optional.Absent,
    facets: Optional[Map[String, zio.aws.cloudsearchdomain.model.BucketInfo]] =
      Optional.Absent,
    stats: Optional[Map[String, zio.aws.cloudsearchdomain.model.FieldStats]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudsearchdomain.model.SearchResponse = {
    import SearchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudsearchdomain.model.SearchResponse
      .builder()
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(hits.map(value => value.buildAwsValue()))(_.hits)
      .optionallyWith(
        facets.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.facets)
      .optionallyWith(
        stats.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.stats)
      .build()
  }
  def asReadOnly: zio.aws.cloudsearchdomain.model.SearchResponse.ReadOnly =
    zio.aws.cloudsearchdomain.model.SearchResponse.wrap(buildAwsValue())
}
object SearchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudsearchdomain.model.SearchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudsearchdomain.model.SearchResponse =
      zio.aws.cloudsearchdomain.model.SearchResponse(
        status.map(value => value.asEditable),
        hits.map(value => value.asEditable),
        facets.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        stats.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def status: Optional[zio.aws.cloudsearchdomain.model.SearchStatus.ReadOnly]
    def hits: Optional[zio.aws.cloudsearchdomain.model.Hits.ReadOnly]
    def facets: Optional[
      Map[String, zio.aws.cloudsearchdomain.model.BucketInfo.ReadOnly]
    ]
    def stats: Optional[
      Map[String, zio.aws.cloudsearchdomain.model.FieldStats.ReadOnly]
    ]
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.cloudsearchdomain.model.SearchStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getHits
        : ZIO[Any, AwsError, zio.aws.cloudsearchdomain.model.Hits.ReadOnly] =
      AwsError.unwrapOptionField("hits", hits)
    def getFacets: ZIO[Any, AwsError, Map[
      String,
      zio.aws.cloudsearchdomain.model.BucketInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("facets", facets)
    def getStats: ZIO[Any, AwsError, Map[
      String,
      zio.aws.cloudsearchdomain.model.FieldStats.ReadOnly
    ]] = AwsError.unwrapOptionField("stats", stats)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.SearchResponse
  ) extends zio.aws.cloudsearchdomain.model.SearchResponse.ReadOnly {
    override val status
        : Optional[zio.aws.cloudsearchdomain.model.SearchStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.cloudsearchdomain.model.SearchStatus.wrap(value))
    override val hits: Optional[zio.aws.cloudsearchdomain.model.Hits.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hits())
        .map(value => zio.aws.cloudsearchdomain.model.Hits.wrap(value))
    override val facets: Optional[
      Map[String, zio.aws.cloudsearchdomain.model.BucketInfo.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.facets())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.cloudsearchdomain.model.BucketInfo
              .wrap(value)
          })
          .toMap
      )
    override val stats: Optional[
      Map[String, zio.aws.cloudsearchdomain.model.FieldStats.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.stats())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.cloudsearchdomain.model.FieldStats
              .wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.SearchResponse
  ): zio.aws.cloudsearchdomain.model.SearchResponse.ReadOnly = new Wrapper(impl)
}
