package zio.aws.cloudsearchdomain.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UploadDocumentsRequest(
    contentType: zio.aws.cloudsearchdomain.model.ContentType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudsearchdomain.model.UploadDocumentsRequest = {
    import UploadDocumentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudsearchdomain.model.UploadDocumentsRequest
      .builder()
      .contentType(contentType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudsearchdomain.model.UploadDocumentsRequest.ReadOnly =
    zio.aws.cloudsearchdomain.model.UploadDocumentsRequest.wrap(buildAwsValue())
}
object UploadDocumentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudsearchdomain.model.UploadDocumentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudsearchdomain.model.UploadDocumentsRequest =
      zio.aws.cloudsearchdomain.model.UploadDocumentsRequest(contentType)
    def contentType: zio.aws.cloudsearchdomain.model.ContentType
    def getContentType
        : ZIO[Any, Nothing, zio.aws.cloudsearchdomain.model.ContentType] =
      ZIO.succeed(contentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.UploadDocumentsRequest
  ) extends zio.aws.cloudsearchdomain.model.UploadDocumentsRequest.ReadOnly {
    override val contentType: zio.aws.cloudsearchdomain.model.ContentType =
      zio.aws.cloudsearchdomain.model.ContentType.wrap(impl.contentType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.UploadDocumentsRequest
  ): zio.aws.cloudsearchdomain.model.UploadDocumentsRequest.ReadOnly =
    new Wrapper(impl)
}
