package zio.aws.cloudsearchdomain.model
import scala.jdk.CollectionConverters._
sealed trait ContentType {
  def unwrap
      : software.amazon.awssdk.services.cloudsearchdomain.model.ContentType
}
object ContentType {
  def wrap(
      value: software.amazon.awssdk.services.cloudsearchdomain.model.ContentType
  ): zio.aws.cloudsearchdomain.model.ContentType = value match {
    case software.amazon.awssdk.services.cloudsearchdomain.model.ContentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudsearchdomain.model.ContentType.APPLICATION_JSON =>
      val r = `application/json`
      r
    case software.amazon.awssdk.services.cloudsearchdomain.model.ContentType.APPLICATION_XML =>
      val r = `application/xml`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudsearchdomain.model.ContentType {
    override def unwrap
        : software.amazon.awssdk.services.cloudsearchdomain.model.ContentType =
      software.amazon.awssdk.services.cloudsearchdomain.model.ContentType.UNKNOWN_TO_SDK_VERSION
  }
  case object `application/json`
      extends zio.aws.cloudsearchdomain.model.ContentType {
    override def unwrap
        : software.amazon.awssdk.services.cloudsearchdomain.model.ContentType =
      software.amazon.awssdk.services.cloudsearchdomain.model.ContentType.APPLICATION_JSON
  }
  case object `application/xml`
      extends zio.aws.cloudsearchdomain.model.ContentType {
    override def unwrap
        : software.amazon.awssdk.services.cloudsearchdomain.model.ContentType =
      software.amazon.awssdk.services.cloudsearchdomain.model.ContentType.APPLICATION_XML
  }
}
