package zio.aws.cloudsearchdomain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BucketInfo(
    buckets: Optional[Iterable[zio.aws.cloudsearchdomain.model.Bucket]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudsearchdomain.model.BucketInfo = {
    import BucketInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudsearchdomain.model.BucketInfo
      .builder()
      .optionallyWith(
        buckets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.buckets)
      .build()
  }
  def asReadOnly: zio.aws.cloudsearchdomain.model.BucketInfo.ReadOnly =
    zio.aws.cloudsearchdomain.model.BucketInfo.wrap(buildAwsValue())
}
object BucketInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudsearchdomain.model.BucketInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudsearchdomain.model.BucketInfo =
      zio.aws.cloudsearchdomain.model.BucketInfo(
        buckets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def buckets: Optional[List[zio.aws.cloudsearchdomain.model.Bucket.ReadOnly]]
    def getBuckets: ZIO[Any, AwsError, List[
      zio.aws.cloudsearchdomain.model.Bucket.ReadOnly
    ]] = AwsError.unwrapOptionField("buckets", buckets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.BucketInfo
  ) extends zio.aws.cloudsearchdomain.model.BucketInfo.ReadOnly {
    override val buckets
        : Optional[List[zio.aws.cloudsearchdomain.model.Bucket.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.buckets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudsearchdomain.model.Bucket.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.BucketInfo
  ): zio.aws.cloudsearchdomain.model.BucketInfo.ReadOnly = new Wrapper(impl)
}
