package zio.aws.cloudsearchdomain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FieldStats(
    min: Optional[String] = Optional.Absent,
    max: Optional[String] = Optional.Absent,
    count: Optional[Long] = Optional.Absent,
    missing: Optional[Long] = Optional.Absent,
    sum: Optional[Double] = Optional.Absent,
    sumOfSquares: Optional[Double] = Optional.Absent,
    mean: Optional[String] = Optional.Absent,
    stddev: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudsearchdomain.model.FieldStats = {
    import FieldStats.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudsearchdomain.model.FieldStats
      .builder()
      .optionallyWith(min.map(value => value: java.lang.String))(_.min)
      .optionallyWith(max.map(value => value: java.lang.String))(_.max)
      .optionallyWith(count.map(value => value: java.lang.Long))(_.count)
      .optionallyWith(missing.map(value => value: java.lang.Long))(_.missing)
      .optionallyWith(sum.map(value => value: java.lang.Double))(_.sum)
      .optionallyWith(sumOfSquares.map(value => value: java.lang.Double))(
        _.sumOfSquares
      )
      .optionallyWith(mean.map(value => value: java.lang.String))(_.mean)
      .optionallyWith(stddev.map(value => value: java.lang.Double))(_.stddev)
      .build()
  }
  def asReadOnly: zio.aws.cloudsearchdomain.model.FieldStats.ReadOnly =
    zio.aws.cloudsearchdomain.model.FieldStats.wrap(buildAwsValue())
}
object FieldStats {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudsearchdomain.model.FieldStats
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudsearchdomain.model.FieldStats =
      zio.aws.cloudsearchdomain.model.FieldStats(
        min.map(value => value),
        max.map(value => value),
        count.map(value => value),
        missing.map(value => value),
        sum.map(value => value),
        sumOfSquares.map(value => value),
        mean.map(value => value),
        stddev.map(value => value)
      )
    def min: Optional[String]
    def max: Optional[String]
    def count: Optional[Long]
    def missing: Optional[Long]
    def sum: Optional[Double]
    def sumOfSquares: Optional[Double]
    def mean: Optional[String]
    def stddev: Optional[Double]
    def getMin: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("min", min)
    def getMax: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("max", max)
    def getCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("count", count)
    def getMissing: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("missing", missing)
    def getSum: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("sum", sum)
    def getSumOfSquares: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("sumOfSquares", sumOfSquares)
    def getMean: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("mean", mean)
    def getStddev: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("stddev", stddev)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.FieldStats
  ) extends zio.aws.cloudsearchdomain.model.FieldStats.ReadOnly {
    override val min: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.min())
      .map(value => value: String)
    override val max: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.max())
      .map(value => value: String)
    override val count: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => value: Long)
    override val missing: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.missing())
      .map(value => value: Long)
    override val sum: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.sum())
      .map(value => value: Double)
    override val sumOfSquares: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.sumOfSquares())
      .map(value => value: Double)
    override val mean: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.mean())
      .map(value => value: String)
    override val stddev: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.stddev())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.FieldStats
  ): zio.aws.cloudsearchdomain.model.FieldStats.ReadOnly = new Wrapper(impl)
}
