package zio.aws.cloudsearchdomain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SearchResponse(
    status: Option[zio.aws.cloudsearchdomain.model.SearchStatus] = None,
    hits: Option[zio.aws.cloudsearchdomain.model.Hits] = None,
    facets: Option[Map[String, zio.aws.cloudsearchdomain.model.BucketInfo]] =
      None,
    stats: Option[Map[String, zio.aws.cloudsearchdomain.model.FieldStats]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudsearchdomain.model.SearchResponse = {
    import SearchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudsearchdomain.model.SearchResponse
      .builder()
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(hits.map(value => value.buildAwsValue()))(_.hits)
      .optionallyWith(
        facets.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.facets)
      .optionallyWith(
        stats.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.stats)
      .build()
  }
  def asReadOnly: zio.aws.cloudsearchdomain.model.SearchResponse.ReadOnly =
    zio.aws.cloudsearchdomain.model.SearchResponse.wrap(buildAwsValue())
}
object SearchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudsearchdomain.model.SearchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudsearchdomain.model.SearchResponse =
      zio.aws.cloudsearchdomain.model.SearchResponse(
        status.map(value => value.asEditable),
        hits.map(value => value.asEditable),
        facets.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        stats.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def status: Option[zio.aws.cloudsearchdomain.model.SearchStatus.ReadOnly]
    def hits: Option[zio.aws.cloudsearchdomain.model.Hits.ReadOnly]
    def facets: Option[
      Map[String, zio.aws.cloudsearchdomain.model.BucketInfo.ReadOnly]
    ]
    def stats: Option[
      Map[String, zio.aws.cloudsearchdomain.model.FieldStats.ReadOnly]
    ]
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.cloudsearchdomain.model.SearchStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getHits
        : ZIO[Any, AwsError, zio.aws.cloudsearchdomain.model.Hits.ReadOnly] =
      AwsError.unwrapOptionField("hits", hits)
    def getFacets: ZIO[Any, AwsError, Map[
      String,
      zio.aws.cloudsearchdomain.model.BucketInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("facets", facets)
    def getStats: ZIO[Any, AwsError, Map[
      String,
      zio.aws.cloudsearchdomain.model.FieldStats.ReadOnly
    ]] = AwsError.unwrapOptionField("stats", stats)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.SearchResponse
  ) extends zio.aws.cloudsearchdomain.model.SearchResponse.ReadOnly {
    override val status
        : Option[zio.aws.cloudsearchdomain.model.SearchStatus.ReadOnly] = scala
      .Option(impl.status())
      .map(value => zio.aws.cloudsearchdomain.model.SearchStatus.wrap(value))
    override val hits: Option[zio.aws.cloudsearchdomain.model.Hits.ReadOnly] =
      scala
        .Option(impl.hits())
        .map(value => zio.aws.cloudsearchdomain.model.Hits.wrap(value))
    override val facets: Option[
      Map[String, zio.aws.cloudsearchdomain.model.BucketInfo.ReadOnly]
    ] = scala
      .Option(impl.facets())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.cloudsearchdomain.model.BucketInfo
              .wrap(value)
          })
          .toMap
      )
    override val stats: Option[
      Map[String, zio.aws.cloudsearchdomain.model.FieldStats.ReadOnly]
    ] = scala
      .Option(impl.stats())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.cloudsearchdomain.model.FieldStats
              .wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.SearchResponse
  ): zio.aws.cloudsearchdomain.model.SearchResponse.ReadOnly = new Wrapper(impl)
}
