package zio.aws.cloudsearchdomain.model
import zio.ZIO
import zio.aws.cloudsearchdomain.model.primitives.{
  Cursor,
  Sort,
  Highlight,
  Stat,
  Partial,
  Facet,
  FilterQuery,
  QueryOptions,
  Start,
  Query,
  Size,
  Expr,
  Return
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SearchRequest(
    cursor: Option[Cursor] = None,
    expr: Option[Expr] = None,
    facet: Option[Facet] = None,
    filterQuery: Option[FilterQuery] = None,
    highlight: Option[Highlight] = None,
    partial: Option[Partial] = None,
    query: Query,
    queryOptions: Option[QueryOptions] = None,
    queryParser: Option[zio.aws.cloudsearchdomain.model.QueryParser] = None,
    returnValues: Option[Return] = None,
    size: Option[Size] = None,
    sort: Option[Sort] = None,
    start: Option[Start] = None,
    stats: Option[Stat] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudsearchdomain.model.SearchRequest = {
    import SearchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudsearchdomain.model.SearchRequest
      .builder()
      .optionallyWith(
        cursor.map(value => Cursor.unwrap(value): java.lang.String)
      )(_.cursor)
      .optionallyWith(expr.map(value => Expr.unwrap(value): java.lang.String))(
        _.expr
      )
      .optionallyWith(
        facet.map(value => Facet.unwrap(value): java.lang.String)
      )(_.facet)
      .optionallyWith(
        filterQuery.map(value => FilterQuery.unwrap(value): java.lang.String)
      )(_.filterQuery)
      .optionallyWith(
        highlight.map(value => Highlight.unwrap(value): java.lang.String)
      )(_.highlight)
      .optionallyWith(
        partial.map(value => Partial.unwrap(value): java.lang.Boolean)
      )(_.partial)
      .query(Query.unwrap(query): java.lang.String)
      .optionallyWith(
        queryOptions.map(value => QueryOptions.unwrap(value): java.lang.String)
      )(_.queryOptions)
      .optionallyWith(queryParser.map(value => value.unwrap))(_.queryParser)
      .optionallyWith(
        returnValues.map(value => Return.unwrap(value): java.lang.String)
      )(_.returnValues)
      .optionallyWith(size.map(value => Size.unwrap(value): java.lang.Long))(
        _.size
      )
      .optionallyWith(sort.map(value => Sort.unwrap(value): java.lang.String))(
        _.sort
      )
      .optionallyWith(start.map(value => Start.unwrap(value): java.lang.Long))(
        _.start
      )
      .optionallyWith(stats.map(value => Stat.unwrap(value): java.lang.String))(
        _.stats
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudsearchdomain.model.SearchRequest.ReadOnly =
    zio.aws.cloudsearchdomain.model.SearchRequest.wrap(buildAwsValue())
}
object SearchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudsearchdomain.model.SearchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudsearchdomain.model.SearchRequest =
      zio.aws.cloudsearchdomain.model.SearchRequest(
        cursor.map(value => value),
        expr.map(value => value),
        facet.map(value => value),
        filterQuery.map(value => value),
        highlight.map(value => value),
        partial.map(value => value),
        query,
        queryOptions.map(value => value),
        queryParser.map(value => value),
        returnValues.map(value => value),
        size.map(value => value),
        sort.map(value => value),
        start.map(value => value),
        stats.map(value => value)
      )
    def cursor: Option[Cursor]
    def expr: Option[Expr]
    def facet: Option[Facet]
    def filterQuery: Option[FilterQuery]
    def highlight: Option[Highlight]
    def partial: Option[Partial]
    def query: Query
    def queryOptions: Option[QueryOptions]
    def queryParser: Option[zio.aws.cloudsearchdomain.model.QueryParser]
    def returnValues: Option[Return]
    def size: Option[Size]
    def sort: Option[Sort]
    def start: Option[Start]
    def stats: Option[Stat]
    def getCursor: ZIO[Any, AwsError, Cursor] =
      AwsError.unwrapOptionField("cursor", cursor)
    def getExpr: ZIO[Any, AwsError, Expr] =
      AwsError.unwrapOptionField("expr", expr)
    def getFacet: ZIO[Any, AwsError, Facet] =
      AwsError.unwrapOptionField("facet", facet)
    def getFilterQuery: ZIO[Any, AwsError, FilterQuery] =
      AwsError.unwrapOptionField("filterQuery", filterQuery)
    def getHighlight: ZIO[Any, AwsError, Highlight] =
      AwsError.unwrapOptionField("highlight", highlight)
    def getPartial: ZIO[Any, AwsError, Partial] =
      AwsError.unwrapOptionField("partial", partial)
    def getQuery: ZIO[Any, Nothing, Query] = ZIO.succeed(query)
    def getQueryOptions: ZIO[Any, AwsError, QueryOptions] =
      AwsError.unwrapOptionField("queryOptions", queryOptions)
    def getQueryParser
        : ZIO[Any, AwsError, zio.aws.cloudsearchdomain.model.QueryParser] =
      AwsError.unwrapOptionField("queryParser", queryParser)
    def getReturnValues: ZIO[Any, AwsError, Return] =
      AwsError.unwrapOptionField("returnValues", returnValues)
    def getSize: ZIO[Any, AwsError, Size] =
      AwsError.unwrapOptionField("size", size)
    def getSort: ZIO[Any, AwsError, Sort] =
      AwsError.unwrapOptionField("sort", sort)
    def getStart: ZIO[Any, AwsError, Start] =
      AwsError.unwrapOptionField("start", start)
    def getStats: ZIO[Any, AwsError, Stat] =
      AwsError.unwrapOptionField("stats", stats)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.SearchRequest
  ) extends zio.aws.cloudsearchdomain.model.SearchRequest.ReadOnly {
    override val cursor: Option[Cursor] = scala
      .Option(impl.cursor())
      .map(value => zio.aws.cloudsearchdomain.model.primitives.Cursor(value))
    override val expr: Option[Expr] = scala
      .Option(impl.expr())
      .map(value => zio.aws.cloudsearchdomain.model.primitives.Expr(value))
    override val facet: Option[Facet] = scala
      .Option(impl.facet())
      .map(value => zio.aws.cloudsearchdomain.model.primitives.Facet(value))
    override val filterQuery: Option[FilterQuery] = scala
      .Option(impl.filterQuery())
      .map(value =>
        zio.aws.cloudsearchdomain.model.primitives.FilterQuery(value)
      )
    override val highlight: Option[Highlight] = scala
      .Option(impl.highlight())
      .map(value => zio.aws.cloudsearchdomain.model.primitives.Highlight(value))
    override val partial: Option[Partial] = scala
      .Option(impl.partial())
      .map(value => zio.aws.cloudsearchdomain.model.primitives.Partial(value))
    override val query: Query =
      zio.aws.cloudsearchdomain.model.primitives.Query(impl.query())
    override val queryOptions: Option[QueryOptions] = scala
      .Option(impl.queryOptions())
      .map(value =>
        zio.aws.cloudsearchdomain.model.primitives.QueryOptions(value)
      )
    override val queryParser
        : Option[zio.aws.cloudsearchdomain.model.QueryParser] = scala
      .Option(impl.queryParser())
      .map(value => zio.aws.cloudsearchdomain.model.QueryParser.wrap(value))
    override val returnValues: Option[Return] = scala
      .Option(impl.returnValues())
      .map(value => zio.aws.cloudsearchdomain.model.primitives.Return(value))
    override val size: Option[Size] = scala
      .Option(impl.size())
      .map(value => zio.aws.cloudsearchdomain.model.primitives.Size(value))
    override val sort: Option[Sort] = scala
      .Option(impl.sort())
      .map(value => zio.aws.cloudsearchdomain.model.primitives.Sort(value))
    override val start: Option[Start] = scala
      .Option(impl.start())
      .map(value => zio.aws.cloudsearchdomain.model.primitives.Start(value))
    override val stats: Option[Stat] = scala
      .Option(impl.stats())
      .map(value => zio.aws.cloudsearchdomain.model.primitives.Stat(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.SearchRequest
  ): zio.aws.cloudsearchdomain.model.SearchRequest.ReadOnly = new Wrapper(impl)
}
