package zio.aws.cloudsearchdomain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SuggestResponse(
    status: Option[zio.aws.cloudsearchdomain.model.SuggestStatus] = None,
    suggest: Option[zio.aws.cloudsearchdomain.model.SuggestModel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudsearchdomain.model.SuggestResponse = {
    import SuggestResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudsearchdomain.model.SuggestResponse
      .builder()
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(suggest.map(value => value.buildAwsValue()))(_.suggest)
      .build()
  }
  def asReadOnly: zio.aws.cloudsearchdomain.model.SuggestResponse.ReadOnly =
    zio.aws.cloudsearchdomain.model.SuggestResponse.wrap(buildAwsValue())
}
object SuggestResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudsearchdomain.model.SuggestResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudsearchdomain.model.SuggestResponse =
      zio.aws.cloudsearchdomain.model.SuggestResponse(
        status.map(value => value.asEditable),
        suggest.map(value => value.asEditable)
      )
    def status: Option[zio.aws.cloudsearchdomain.model.SuggestStatus.ReadOnly]
    def suggest: Option[zio.aws.cloudsearchdomain.model.SuggestModel.ReadOnly]
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.cloudsearchdomain.model.SuggestStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getSuggest: ZIO[
      Any,
      AwsError,
      zio.aws.cloudsearchdomain.model.SuggestModel.ReadOnly
    ] = AwsError.unwrapOptionField("suggest", suggest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.SuggestResponse
  ) extends zio.aws.cloudsearchdomain.model.SuggestResponse.ReadOnly {
    override val status
        : Option[zio.aws.cloudsearchdomain.model.SuggestStatus.ReadOnly] = scala
      .Option(impl.status())
      .map(value => zio.aws.cloudsearchdomain.model.SuggestStatus.wrap(value))
    override val suggest
        : Option[zio.aws.cloudsearchdomain.model.SuggestModel.ReadOnly] = scala
      .Option(impl.suggest())
      .map(value => zio.aws.cloudsearchdomain.model.SuggestModel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.SuggestResponse
  ): zio.aws.cloudsearchdomain.model.SuggestResponse.ReadOnly = new Wrapper(
    impl
  )
}
