package zio.aws.cloudsearchdomain.model
import scala.jdk.CollectionConverters._
sealed trait QueryParser {
  def unwrap
      : software.amazon.awssdk.services.cloudsearchdomain.model.QueryParser
}
object QueryParser {
  def wrap(
      value: software.amazon.awssdk.services.cloudsearchdomain.model.QueryParser
  ): zio.aws.cloudsearchdomain.model.QueryParser = value match {
    case software.amazon.awssdk.services.cloudsearchdomain.model.QueryParser.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudsearchdomain.model.QueryParser.SIMPLE =>
      val r = simple
      r
    case software.amazon.awssdk.services.cloudsearchdomain.model.QueryParser.STRUCTURED =>
      val r = structured
      r
    case software.amazon.awssdk.services.cloudsearchdomain.model.QueryParser.LUCENE =>
      val r = lucene
      r
    case software.amazon.awssdk.services.cloudsearchdomain.model.QueryParser.DISMAX =>
      val r = dismax
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudsearchdomain.model.QueryParser {
    override def unwrap
        : software.amazon.awssdk.services.cloudsearchdomain.model.QueryParser =
      software.amazon.awssdk.services.cloudsearchdomain.model.QueryParser.UNKNOWN_TO_SDK_VERSION
  }
  case object simple extends zio.aws.cloudsearchdomain.model.QueryParser {
    override def unwrap
        : software.amazon.awssdk.services.cloudsearchdomain.model.QueryParser =
      software.amazon.awssdk.services.cloudsearchdomain.model.QueryParser.SIMPLE
  }
  case object structured extends zio.aws.cloudsearchdomain.model.QueryParser {
    override def unwrap
        : software.amazon.awssdk.services.cloudsearchdomain.model.QueryParser =
      software.amazon.awssdk.services.cloudsearchdomain.model.QueryParser.STRUCTURED
  }
  case object lucene extends zio.aws.cloudsearchdomain.model.QueryParser {
    override def unwrap
        : software.amazon.awssdk.services.cloudsearchdomain.model.QueryParser =
      software.amazon.awssdk.services.cloudsearchdomain.model.QueryParser.LUCENE
  }
  case object dismax extends zio.aws.cloudsearchdomain.model.QueryParser {
    override def unwrap
        : software.amazon.awssdk.services.cloudsearchdomain.model.QueryParser =
      software.amazon.awssdk.services.cloudsearchdomain.model.QueryParser.DISMAX
  }
}
