package zio.aws.cloudsearchdomain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Hit(
    id: Option[String] = None,
    fields: Option[Map[String, Iterable[String]]] = None,
    exprs: Option[Map[String, String]] = None,
    highlights: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudsearchdomain.model.Hit = {
    import Hit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudsearchdomain.model.Hit
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(
        fields.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.fields)
      .optionallyWith(
        exprs.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.exprs)
      .optionallyWith(
        highlights.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.highlights)
      .build()
  }
  def asReadOnly: zio.aws.cloudsearchdomain.model.Hit.ReadOnly =
    zio.aws.cloudsearchdomain.model.Hit.wrap(buildAwsValue())
}
object Hit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudsearchdomain.model.Hit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudsearchdomain.model.Hit =
      zio.aws.cloudsearchdomain.model.Hit(
        id.map(value => value),
        fields.map(value => value),
        exprs.map(value => value),
        highlights.map(value => value)
      )
    def id: Option[String]
    def fields: Option[Map[String, List[String]]]
    def exprs: Option[Map[String, String]]
    def highlights: Option[Map[String, String]]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getFields: ZIO[Any, AwsError, Map[String, List[String]]] =
      AwsError.unwrapOptionField("fields", fields)
    def getExprs: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("exprs", exprs)
    def getHighlights: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("highlights", highlights)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.Hit
  ) extends zio.aws.cloudsearchdomain.model.Hit.ReadOnly {
    override val id: Option[String] =
      scala.Option(impl.id()).map(value => value: String)
    override val fields: Option[Map[String, List[String]]] = scala
      .Option(impl.fields())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> value.asScala.map { item =>
              item: String
            }.toList
          })
          .toMap
      )
    override val exprs: Option[Map[String, String]] = scala
      .Option(impl.exprs())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val highlights: Option[Map[String, String]] = scala
      .Option(impl.highlights())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.Hit
  ): zio.aws.cloudsearchdomain.model.Hit.ReadOnly = new Wrapper(impl)
}
