package zio.aws.cloudsearchdomain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SearchStatus(
    timems: Option[Long] = None,
    rid: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudsearchdomain.model.SearchStatus = {
    import SearchStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudsearchdomain.model.SearchStatus
      .builder()
      .optionallyWith(timems.map(value => value: java.lang.Long))(_.timems)
      .optionallyWith(rid.map(value => value: java.lang.String))(_.rid)
      .build()
  }
  def asReadOnly: zio.aws.cloudsearchdomain.model.SearchStatus.ReadOnly =
    zio.aws.cloudsearchdomain.model.SearchStatus.wrap(buildAwsValue())
}
object SearchStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudsearchdomain.model.SearchStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudsearchdomain.model.SearchStatus =
      zio.aws.cloudsearchdomain.model
        .SearchStatus(timems.map(value => value), rid.map(value => value))
    def timems: Option[Long]
    def rid: Option[String]
    def getTimems: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("timems", timems)
    def getRid: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("rid", rid)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.SearchStatus
  ) extends zio.aws.cloudsearchdomain.model.SearchStatus.ReadOnly {
    override val timems: Option[Long] =
      scala.Option(impl.timems()).map(value => value: Long)
    override val rid: Option[String] =
      scala.Option(impl.rid()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.SearchStatus
  ): zio.aws.cloudsearchdomain.model.SearchStatus.ReadOnly = new Wrapper(impl)
}
