package zio.aws.cloudsearchdomain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SuggestionMatch(
    suggestion: Option[String] = None,
    score: Option[Long] = None,
    id: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudsearchdomain.model.SuggestionMatch = {
    import SuggestionMatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudsearchdomain.model.SuggestionMatch
      .builder()
      .optionallyWith(suggestion.map(value => value: java.lang.String))(
        _.suggestion
      )
      .optionallyWith(score.map(value => value: java.lang.Long))(_.score)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .build()
  }
  def asReadOnly: zio.aws.cloudsearchdomain.model.SuggestionMatch.ReadOnly =
    zio.aws.cloudsearchdomain.model.SuggestionMatch.wrap(buildAwsValue())
}
object SuggestionMatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudsearchdomain.model.SuggestionMatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudsearchdomain.model.SuggestionMatch =
      zio.aws.cloudsearchdomain.model.SuggestionMatch(
        suggestion.map(value => value),
        score.map(value => value),
        id.map(value => value)
      )
    def suggestion: Option[String]
    def score: Option[Long]
    def id: Option[String]
    def getSuggestion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("suggestion", suggestion)
    def getScore: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("score", score)
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.SuggestionMatch
  ) extends zio.aws.cloudsearchdomain.model.SuggestionMatch.ReadOnly {
    override val suggestion: Option[String] =
      scala.Option(impl.suggestion()).map(value => value: String)
    override val score: Option[Long] =
      scala.Option(impl.score()).map(value => value: Long)
    override val id: Option[String] =
      scala.Option(impl.id()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.SuggestionMatch
  ): zio.aws.cloudsearchdomain.model.SuggestionMatch.ReadOnly = new Wrapper(
    impl
  )
}
