package zio.aws.cloudsearchdomain.model
import zio.ZIO
import zio.aws.cloudsearchdomain.model.primitives.{Deletes, Adds}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UploadDocumentsResponse(
    status: Option[String] = None,
    adds: Option[Adds] = None,
    deletes: Option[Deletes] = None,
    warnings: Option[
      Iterable[zio.aws.cloudsearchdomain.model.DocumentServiceWarning]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudsearchdomain.model.UploadDocumentsResponse = {
    import UploadDocumentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudsearchdomain.model.UploadDocumentsResponse
      .builder()
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(adds.map(value => Adds.unwrap(value): java.lang.Long))(
        _.adds
      )
      .optionallyWith(
        deletes.map(value => Deletes.unwrap(value): java.lang.Long)
      )(_.deletes)
      .optionallyWith(
        warnings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.warnings)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudsearchdomain.model.UploadDocumentsResponse.ReadOnly =
    zio.aws.cloudsearchdomain.model.UploadDocumentsResponse
      .wrap(buildAwsValue())
}
object UploadDocumentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudsearchdomain.model.UploadDocumentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudsearchdomain.model.UploadDocumentsResponse =
      zio.aws.cloudsearchdomain.model.UploadDocumentsResponse(
        status.map(value => value),
        adds.map(value => value),
        deletes.map(value => value),
        warnings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def status: Option[String]
    def adds: Option[Adds]
    def deletes: Option[Deletes]
    def warnings: Option[
      List[zio.aws.cloudsearchdomain.model.DocumentServiceWarning.ReadOnly]
    ]
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getAdds: ZIO[Any, AwsError, Adds] =
      AwsError.unwrapOptionField("adds", adds)
    def getDeletes: ZIO[Any, AwsError, Deletes] =
      AwsError.unwrapOptionField("deletes", deletes)
    def getWarnings: ZIO[Any, AwsError, List[
      zio.aws.cloudsearchdomain.model.DocumentServiceWarning.ReadOnly
    ]] = AwsError.unwrapOptionField("warnings", warnings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.UploadDocumentsResponse
  ) extends zio.aws.cloudsearchdomain.model.UploadDocumentsResponse.ReadOnly {
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val adds: Option[Adds] = scala
      .Option(impl.adds())
      .map(value => zio.aws.cloudsearchdomain.model.primitives.Adds(value))
    override val deletes: Option[Deletes] = scala
      .Option(impl.deletes())
      .map(value => zio.aws.cloudsearchdomain.model.primitives.Deletes(value))
    override val warnings: Option[
      List[zio.aws.cloudsearchdomain.model.DocumentServiceWarning.ReadOnly]
    ] = scala
      .Option(impl.warnings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudsearchdomain.model.DocumentServiceWarning.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.UploadDocumentsResponse
  ): zio.aws.cloudsearchdomain.model.UploadDocumentsResponse.ReadOnly =
    new Wrapper(impl)
}
