package zio.aws.cloudsearchdomain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DocumentServiceWarning(message: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudsearchdomain.model.DocumentServiceWarning = {
    import DocumentServiceWarning.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudsearchdomain.model.DocumentServiceWarning
      .builder()
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudsearchdomain.model.DocumentServiceWarning.ReadOnly =
    zio.aws.cloudsearchdomain.model.DocumentServiceWarning.wrap(buildAwsValue())
}
object DocumentServiceWarning {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudsearchdomain.model.DocumentServiceWarning
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudsearchdomain.model.DocumentServiceWarning =
      zio.aws.cloudsearchdomain.model
        .DocumentServiceWarning(message.map(value => value))
    def message: Option[String]
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.DocumentServiceWarning
  ) extends zio.aws.cloudsearchdomain.model.DocumentServiceWarning.ReadOnly {
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.DocumentServiceWarning
  ): zio.aws.cloudsearchdomain.model.DocumentServiceWarning.ReadOnly =
    new Wrapper(impl)
}
