package zio.aws.cloudsearchdomain
import zio.aws.cloudsearchdomain.model.{
  UploadDocumentsRequest,
  SuggestRequest,
  SearchRequest
}
import zio.aws.cloudsearchdomain.model.SearchResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.cloudsearchdomain.model.{
  SuggestResponse,
  SearchResponse,
  UploadDocumentsResponse
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.cloudsearchdomain.{
  CloudSearchDomainAsyncClientBuilder,
  CloudSearchDomainAsyncClient
}
import scala.jdk.CollectionConverters._
trait CloudSearchDomain extends AspectSupport[CloudSearchDomain] {
  val api: CloudSearchDomainAsyncClient
  def search(request: SearchRequest): IO[AwsError, ReadOnly]
  def suggest(
      request: SuggestRequest
  ): IO[AwsError, zio.aws.cloudsearchdomain.model.SuggestResponse.ReadOnly]
  def uploadDocuments(
      request: UploadDocumentsRequest,
      body: ZStream[Any, AwsError, Byte]
  ): IO[
    AwsError,
    zio.aws.cloudsearchdomain.model.UploadDocumentsResponse.ReadOnly
  ]
}
object CloudSearchDomain {
  val live: ZLayer[AwsConfig, java.lang.Throwable, CloudSearchDomain] =
    customized(identity)
  def customized(
      customization: CloudSearchDomainAsyncClientBuilder => CloudSearchDomainAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, CloudSearchDomain] = managed(
    customization
  ).toLayer
  def managed(
      customization: CloudSearchDomainAsyncClientBuilder => CloudSearchDomainAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, CloudSearchDomain] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = CloudSearchDomainAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[
        CloudSearchDomainAsyncClient,
        CloudSearchDomainAsyncClientBuilder
      ](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        CloudSearchDomainAsyncClient,
        CloudSearchDomainAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new CloudSearchDomainImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class CloudSearchDomainImpl[R](
      override val api: CloudSearchDomainAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends CloudSearchDomain
      with AwsServiceBase[R] {
    override val serviceName: String = "CloudSearchDomain"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): CloudSearchDomainImpl[R1] = new CloudSearchDomainImpl(api, newAspect, r)
    def search(request: SearchRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudsearchdomain.model.SearchRequest,
        SearchResponse
      ]("search", api.search)(request.buildAwsValue())
        .map(zio.aws.cloudsearchdomain.model.SearchResponse.wrap)
        .provideEnvironment(r)
    def suggest(
        request: SuggestRequest
    ): IO[AwsError, zio.aws.cloudsearchdomain.model.SuggestResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudsearchdomain.model.SuggestRequest,
        SuggestResponse
      ]("suggest", api.suggest)(request.buildAwsValue())
        .map(zio.aws.cloudsearchdomain.model.SuggestResponse.wrap)
        .provideEnvironment(r)
    def uploadDocuments(
        request: UploadDocumentsRequest,
        body: ZStream[Any, AwsError, Byte]
    ): IO[
      AwsError,
      zio.aws.cloudsearchdomain.model.UploadDocumentsResponse.ReadOnly
    ] = asyncRequestInputStream[
      software.amazon.awssdk.services.cloudsearchdomain.model.UploadDocumentsRequest,
      UploadDocumentsResponse
    ]("uploadDocuments", api.uploadDocuments)(request.buildAwsValue(), body)
      .map(zio.aws.cloudsearchdomain.model.UploadDocumentsResponse.wrap)
      .provideEnvironment(r)
  }
  def search(
      request: SearchRequest
  ): ZIO[zio.aws.cloudsearchdomain.CloudSearchDomain, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.search(request))
  def suggest(request: SuggestRequest): ZIO[
    zio.aws.cloudsearchdomain.CloudSearchDomain,
    AwsError,
    zio.aws.cloudsearchdomain.model.SuggestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.suggest(request))
  def uploadDocuments(
      request: UploadDocumentsRequest,
      body: ZStream[Any, AwsError, Byte]
  ): ZIO[
    zio.aws.cloudsearchdomain.CloudSearchDomain,
    AwsError,
    zio.aws.cloudsearchdomain.model.UploadDocumentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.uploadDocuments(request, body))
}
