package zio.aws.cloudsearchdomain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Hits(
    found: Option[Long] = None,
    start: Option[Long] = None,
    cursor: Option[String] = None,
    hit: Option[Iterable[zio.aws.cloudsearchdomain.model.Hit]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudsearchdomain.model.Hits = {
    import Hits.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudsearchdomain.model.Hits
      .builder()
      .optionallyWith(found.map(value => value: java.lang.Long))(_.found)
      .optionallyWith(start.map(value => value: java.lang.Long))(_.start)
      .optionallyWith(cursor.map(value => value: java.lang.String))(_.cursor)
      .optionallyWith(
        hit.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hit)
      .build()
  }
  def asReadOnly: zio.aws.cloudsearchdomain.model.Hits.ReadOnly =
    zio.aws.cloudsearchdomain.model.Hits.wrap(buildAwsValue())
}
object Hits {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudsearchdomain.model.Hits
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudsearchdomain.model.Hits =
      zio.aws.cloudsearchdomain.model.Hits(
        found.map(value => value),
        start.map(value => value),
        cursor.map(value => value),
        hit.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def found: Option[Long]
    def start: Option[Long]
    def cursor: Option[String]
    def hit: Option[List[zio.aws.cloudsearchdomain.model.Hit.ReadOnly]]
    def getFound: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("found", found)
    def getStart: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("start", start)
    def getCursor: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cursor", cursor)
    def getHit: ZIO[Any, AwsError, List[
      zio.aws.cloudsearchdomain.model.Hit.ReadOnly
    ]] = AwsError.unwrapOptionField("hit", hit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.Hits
  ) extends zio.aws.cloudsearchdomain.model.Hits.ReadOnly {
    override val found: Option[Long] =
      scala.Option(impl.found()).map(value => value: Long)
    override val start: Option[Long] =
      scala.Option(impl.start()).map(value => value: Long)
    override val cursor: Option[String] =
      scala.Option(impl.cursor()).map(value => value: String)
    override val hit
        : Option[List[zio.aws.cloudsearchdomain.model.Hit.ReadOnly]] = scala
      .Option(impl.hit())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudsearchdomain.model.Hit.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudsearchdomain.model.Hits
  ): zio.aws.cloudsearchdomain.model.Hits.ReadOnly = new Wrapper(impl)
}
