package zio.aws.cloudhsmv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CopyBackupToRegionResponse(
    destinationBackup: Optional[zio.aws.cloudhsmv2.model.DestinationBackup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.CopyBackupToRegionResponse = {
    import CopyBackupToRegionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.CopyBackupToRegionResponse
      .builder()
      .optionallyWith(destinationBackup.map(value => value.buildAwsValue()))(
        _.destinationBackup
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.CopyBackupToRegionResponse.ReadOnly =
    zio.aws.cloudhsmv2.model.CopyBackupToRegionResponse.wrap(buildAwsValue())
}
object CopyBackupToRegionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.CopyBackupToRegionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.CopyBackupToRegionResponse =
      zio.aws.cloudhsmv2.model.CopyBackupToRegionResponse(
        destinationBackup.map(value => value.asEditable)
      )
    def destinationBackup
        : Optional[zio.aws.cloudhsmv2.model.DestinationBackup.ReadOnly]
    def getDestinationBackup: ZIO[
      Any,
      AwsError,
      zio.aws.cloudhsmv2.model.DestinationBackup.ReadOnly
    ] = AwsError.unwrapOptionField("destinationBackup", destinationBackup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.CopyBackupToRegionResponse
  ) extends zio.aws.cloudhsmv2.model.CopyBackupToRegionResponse.ReadOnly {
    override val destinationBackup
        : Optional[zio.aws.cloudhsmv2.model.DestinationBackup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationBackup())
        .map(value => zio.aws.cloudhsmv2.model.DestinationBackup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.CopyBackupToRegionResponse
  ): zio.aws.cloudhsmv2.model.CopyBackupToRegionResponse.ReadOnly = new Wrapper(
    impl
  )
}
