package zio.aws.cloudhsmv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudhsmv2.model.primitives.{
  SubnetId,
  VpcId,
  StateMessage,
  Timestamp,
  SecurityGroup,
  PreCoPassword,
  BackupId,
  ExternalAz,
  HsmType,
  ClusterId
}
import scala.jdk.CollectionConverters._
final case class Cluster(
    backupPolicy: Optional[zio.aws.cloudhsmv2.model.BackupPolicy] =
      Optional.Absent,
    backupRetentionPolicy: Optional[
      zio.aws.cloudhsmv2.model.BackupRetentionPolicy
    ] = Optional.Absent,
    clusterId: Optional[ClusterId] = Optional.Absent,
    createTimestamp: Optional[Timestamp] = Optional.Absent,
    hsms: Optional[Iterable[zio.aws.cloudhsmv2.model.Hsm]] = Optional.Absent,
    hsmType: Optional[HsmType] = Optional.Absent,
    preCoPassword: Optional[PreCoPassword] = Optional.Absent,
    securityGroup: Optional[SecurityGroup] = Optional.Absent,
    sourceBackupId: Optional[BackupId] = Optional.Absent,
    state: Optional[zio.aws.cloudhsmv2.model.ClusterState] = Optional.Absent,
    stateMessage: Optional[StateMessage] = Optional.Absent,
    subnetMapping: Optional[Map[ExternalAz, SubnetId]] = Optional.Absent,
    vpcId: Optional[VpcId] = Optional.Absent,
    certificates: Optional[zio.aws.cloudhsmv2.model.Certificates] =
      Optional.Absent,
    tagList: Optional[Iterable[zio.aws.cloudhsmv2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.Cluster = {
    import Cluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.Cluster
      .builder()
      .optionallyWith(backupPolicy.map(value => value.unwrap))(_.backupPolicy)
      .optionallyWith(
        backupRetentionPolicy.map(value => value.buildAwsValue())
      )(_.backupRetentionPolicy)
      .optionallyWith(
        clusterId.map(value => ClusterId.unwrap(value): java.lang.String)
      )(_.clusterId)
      .optionallyWith(
        createTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createTimestamp)
      .optionallyWith(
        hsms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hsms)
      .optionallyWith(
        hsmType.map(value => HsmType.unwrap(value): java.lang.String)
      )(_.hsmType)
      .optionallyWith(
        preCoPassword.map(value =>
          PreCoPassword.unwrap(value): java.lang.String
        )
      )(_.preCoPassword)
      .optionallyWith(
        securityGroup.map(value =>
          SecurityGroup.unwrap(value): java.lang.String
        )
      )(_.securityGroup)
      .optionallyWith(
        sourceBackupId.map(value => BackupId.unwrap(value): java.lang.String)
      )(_.sourceBackupId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        stateMessage.map(value => StateMessage.unwrap(value): java.lang.String)
      )(_.stateMessage)
      .optionallyWith(
        subnetMapping.map(value =>
          value
            .map({ case (key, value) =>
              (ExternalAz.unwrap(key): java.lang.String) -> (SubnetId.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.subnetMapping)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(certificates.map(value => value.buildAwsValue()))(
        _.certificates
      )
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.Cluster.ReadOnly =
    zio.aws.cloudhsmv2.model.Cluster.wrap(buildAwsValue())
}
object Cluster {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.Cluster
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.Cluster =
      zio.aws.cloudhsmv2.model.Cluster(
        backupPolicy.map(value => value),
        backupRetentionPolicy.map(value => value.asEditable),
        clusterId.map(value => value),
        createTimestamp.map(value => value),
        hsms.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        hsmType.map(value => value),
        preCoPassword.map(value => value),
        securityGroup.map(value => value),
        sourceBackupId.map(value => value),
        state.map(value => value),
        stateMessage.map(value => value),
        subnetMapping.map(value => value),
        vpcId.map(value => value),
        certificates.map(value => value.asEditable),
        tagList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def backupPolicy: Optional[zio.aws.cloudhsmv2.model.BackupPolicy]
    def backupRetentionPolicy
        : Optional[zio.aws.cloudhsmv2.model.BackupRetentionPolicy.ReadOnly]
    def clusterId: Optional[ClusterId]
    def createTimestamp: Optional[Timestamp]
    def hsms: Optional[List[zio.aws.cloudhsmv2.model.Hsm.ReadOnly]]
    def hsmType: Optional[HsmType]
    def preCoPassword: Optional[PreCoPassword]
    def securityGroup: Optional[SecurityGroup]
    def sourceBackupId: Optional[BackupId]
    def state: Optional[zio.aws.cloudhsmv2.model.ClusterState]
    def stateMessage: Optional[StateMessage]
    def subnetMapping: Optional[Map[ExternalAz, SubnetId]]
    def vpcId: Optional[VpcId]
    def certificates: Optional[zio.aws.cloudhsmv2.model.Certificates.ReadOnly]
    def tagList: Optional[List[zio.aws.cloudhsmv2.model.Tag.ReadOnly]]
    def getBackupPolicy
        : ZIO[Any, AwsError, zio.aws.cloudhsmv2.model.BackupPolicy] =
      AwsError.unwrapOptionField("backupPolicy", backupPolicy)
    def getBackupRetentionPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.cloudhsmv2.model.BackupRetentionPolicy.ReadOnly
    ] =
      AwsError.unwrapOptionField("backupRetentionPolicy", backupRetentionPolicy)
    def getClusterId: ZIO[Any, AwsError, ClusterId] =
      AwsError.unwrapOptionField("clusterId", clusterId)
    def getCreateTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createTimestamp", createTimestamp)
    def getHsms
        : ZIO[Any, AwsError, List[zio.aws.cloudhsmv2.model.Hsm.ReadOnly]] =
      AwsError.unwrapOptionField("hsms", hsms)
    def getHsmType: ZIO[Any, AwsError, HsmType] =
      AwsError.unwrapOptionField("hsmType", hsmType)
    def getPreCoPassword: ZIO[Any, AwsError, PreCoPassword] =
      AwsError.unwrapOptionField("preCoPassword", preCoPassword)
    def getSecurityGroup: ZIO[Any, AwsError, SecurityGroup] =
      AwsError.unwrapOptionField("securityGroup", securityGroup)
    def getSourceBackupId: ZIO[Any, AwsError, BackupId] =
      AwsError.unwrapOptionField("sourceBackupId", sourceBackupId)
    def getState: ZIO[Any, AwsError, zio.aws.cloudhsmv2.model.ClusterState] =
      AwsError.unwrapOptionField("state", state)
    def getStateMessage: ZIO[Any, AwsError, StateMessage] =
      AwsError.unwrapOptionField("stateMessage", stateMessage)
    def getSubnetMapping: ZIO[Any, AwsError, Map[ExternalAz, SubnetId]] =
      AwsError.unwrapOptionField("subnetMapping", subnetMapping)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getCertificates
        : ZIO[Any, AwsError, zio.aws.cloudhsmv2.model.Certificates.ReadOnly] =
      AwsError.unwrapOptionField("certificates", certificates)
    def getTagList
        : ZIO[Any, AwsError, List[zio.aws.cloudhsmv2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.Cluster
  ) extends zio.aws.cloudhsmv2.model.Cluster.ReadOnly {
    override val backupPolicy: Optional[zio.aws.cloudhsmv2.model.BackupPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupPolicy())
        .map(value => zio.aws.cloudhsmv2.model.BackupPolicy.wrap(value))
    override val backupRetentionPolicy
        : Optional[zio.aws.cloudhsmv2.model.BackupRetentionPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionPolicy())
        .map(value =>
          zio.aws.cloudhsmv2.model.BackupRetentionPolicy.wrap(value)
        )
    override val clusterId: Optional[ClusterId] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterId())
      .map(value => zio.aws.cloudhsmv2.model.primitives.ClusterId(value))
    override val createTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createTimestamp())
      .map(value => zio.aws.cloudhsmv2.model.primitives.Timestamp(value))
    override val hsms: Optional[List[zio.aws.cloudhsmv2.model.Hsm.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hsms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudhsmv2.model.Hsm.wrap(item)
          }.toList
        )
    override val hsmType: Optional[HsmType] = zio.aws.core.internal
      .optionalFromNullable(impl.hsmType())
      .map(value => zio.aws.cloudhsmv2.model.primitives.HsmType(value))
    override val preCoPassword: Optional[PreCoPassword] = zio.aws.core.internal
      .optionalFromNullable(impl.preCoPassword())
      .map(value => zio.aws.cloudhsmv2.model.primitives.PreCoPassword(value))
    override val securityGroup: Optional[SecurityGroup] = zio.aws.core.internal
      .optionalFromNullable(impl.securityGroup())
      .map(value => zio.aws.cloudhsmv2.model.primitives.SecurityGroup(value))
    override val sourceBackupId: Optional[BackupId] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceBackupId())
      .map(value => zio.aws.cloudhsmv2.model.primitives.BackupId(value))
    override val state: Optional[zio.aws.cloudhsmv2.model.ClusterState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.cloudhsmv2.model.ClusterState.wrap(value))
    override val stateMessage: Optional[StateMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.stateMessage())
      .map(value => zio.aws.cloudhsmv2.model.primitives.StateMessage(value))
    override val subnetMapping: Optional[Map[ExternalAz, SubnetId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetMapping())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.cloudhsmv2.model.primitives.ExternalAz(
                key
              ) -> zio.aws.cloudhsmv2.model.primitives.SubnetId(value)
            })
            .toMap
        )
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.cloudhsmv2.model.primitives.VpcId(value))
    override val certificates
        : Optional[zio.aws.cloudhsmv2.model.Certificates.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificates())
        .map(value => zio.aws.cloudhsmv2.model.Certificates.wrap(value))
    override val tagList
        : Optional[List[zio.aws.cloudhsmv2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudhsmv2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.Cluster
  ): zio.aws.cloudhsmv2.model.Cluster.ReadOnly = new Wrapper(impl)
}
