package zio.aws.cloudhsmv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudhsmv2.model.primitives.{
  ClusterId,
  BackupId,
  Region,
  Timestamp
}
import scala.jdk.CollectionConverters._
final case class DestinationBackup(
    createTimestamp: Optional[Timestamp] = Optional.Absent,
    sourceRegion: Optional[Region] = Optional.Absent,
    sourceBackup: Optional[BackupId] = Optional.Absent,
    sourceCluster: Optional[ClusterId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.DestinationBackup = {
    import DestinationBackup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.DestinationBackup
      .builder()
      .optionallyWith(
        createTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createTimestamp)
      .optionallyWith(
        sourceRegion.map(value => Region.unwrap(value): java.lang.String)
      )(_.sourceRegion)
      .optionallyWith(
        sourceBackup.map(value => BackupId.unwrap(value): java.lang.String)
      )(_.sourceBackup)
      .optionallyWith(
        sourceCluster.map(value => ClusterId.unwrap(value): java.lang.String)
      )(_.sourceCluster)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.DestinationBackup.ReadOnly =
    zio.aws.cloudhsmv2.model.DestinationBackup.wrap(buildAwsValue())
}
object DestinationBackup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.DestinationBackup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.DestinationBackup =
      zio.aws.cloudhsmv2.model.DestinationBackup(
        createTimestamp.map(value => value),
        sourceRegion.map(value => value),
        sourceBackup.map(value => value),
        sourceCluster.map(value => value)
      )
    def createTimestamp: Optional[Timestamp]
    def sourceRegion: Optional[Region]
    def sourceBackup: Optional[BackupId]
    def sourceCluster: Optional[ClusterId]
    def getCreateTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createTimestamp", createTimestamp)
    def getSourceRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("sourceRegion", sourceRegion)
    def getSourceBackup: ZIO[Any, AwsError, BackupId] =
      AwsError.unwrapOptionField("sourceBackup", sourceBackup)
    def getSourceCluster: ZIO[Any, AwsError, ClusterId] =
      AwsError.unwrapOptionField("sourceCluster", sourceCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.DestinationBackup
  ) extends zio.aws.cloudhsmv2.model.DestinationBackup.ReadOnly {
    override val createTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createTimestamp())
      .map(value => zio.aws.cloudhsmv2.model.primitives.Timestamp(value))
    override val sourceRegion: Optional[Region] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceRegion())
      .map(value => zio.aws.cloudhsmv2.model.primitives.Region(value))
    override val sourceBackup: Optional[BackupId] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceBackup())
      .map(value => zio.aws.cloudhsmv2.model.primitives.BackupId(value))
    override val sourceCluster: Optional[ClusterId] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceCluster())
      .map(value => zio.aws.cloudhsmv2.model.primitives.ClusterId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.DestinationBackup
  ): zio.aws.cloudhsmv2.model.DestinationBackup.ReadOnly = new Wrapper(impl)
}
