package zio.aws.cloudhsmv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudhsmv2.model.primitives.{
  Region,
  Timestamp,
  ClusterId,
  BackupId
}
import scala.jdk.CollectionConverters._
final case class Backup(
    backupId: BackupId,
    backupState: Optional[zio.aws.cloudhsmv2.model.BackupState] =
      Optional.Absent,
    clusterId: Optional[ClusterId] = Optional.Absent,
    createTimestamp: Optional[Timestamp] = Optional.Absent,
    copyTimestamp: Optional[Timestamp] = Optional.Absent,
    neverExpires: Optional[Boolean] = Optional.Absent,
    sourceRegion: Optional[Region] = Optional.Absent,
    sourceBackup: Optional[BackupId] = Optional.Absent,
    sourceCluster: Optional[ClusterId] = Optional.Absent,
    deleteTimestamp: Optional[Timestamp] = Optional.Absent,
    tagList: Optional[Iterable[zio.aws.cloudhsmv2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.Backup = {
    import Backup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.Backup
      .builder()
      .backupId(BackupId.unwrap(backupId): java.lang.String)
      .optionallyWith(backupState.map(value => value.unwrap))(_.backupState)
      .optionallyWith(
        clusterId.map(value => ClusterId.unwrap(value): java.lang.String)
      )(_.clusterId)
      .optionallyWith(
        createTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createTimestamp)
      .optionallyWith(
        copyTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.copyTimestamp)
      .optionallyWith(neverExpires.map(value => value: java.lang.Boolean))(
        _.neverExpires
      )
      .optionallyWith(
        sourceRegion.map(value => Region.unwrap(value): java.lang.String)
      )(_.sourceRegion)
      .optionallyWith(
        sourceBackup.map(value => BackupId.unwrap(value): java.lang.String)
      )(_.sourceBackup)
      .optionallyWith(
        sourceCluster.map(value => ClusterId.unwrap(value): java.lang.String)
      )(_.sourceCluster)
      .optionallyWith(
        deleteTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.deleteTimestamp)
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.Backup.ReadOnly =
    zio.aws.cloudhsmv2.model.Backup.wrap(buildAwsValue())
}
object Backup {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.cloudhsmv2.model.Backup] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.Backup =
      zio.aws.cloudhsmv2.model.Backup(
        backupId,
        backupState.map(value => value),
        clusterId.map(value => value),
        createTimestamp.map(value => value),
        copyTimestamp.map(value => value),
        neverExpires.map(value => value),
        sourceRegion.map(value => value),
        sourceBackup.map(value => value),
        sourceCluster.map(value => value),
        deleteTimestamp.map(value => value),
        tagList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def backupId: BackupId
    def backupState: Optional[zio.aws.cloudhsmv2.model.BackupState]
    def clusterId: Optional[ClusterId]
    def createTimestamp: Optional[Timestamp]
    def copyTimestamp: Optional[Timestamp]
    def neverExpires: Optional[Boolean]
    def sourceRegion: Optional[Region]
    def sourceBackup: Optional[BackupId]
    def sourceCluster: Optional[ClusterId]
    def deleteTimestamp: Optional[Timestamp]
    def tagList: Optional[List[zio.aws.cloudhsmv2.model.Tag.ReadOnly]]
    def getBackupId: ZIO[Any, Nothing, BackupId] = ZIO.succeed(backupId)
    def getBackupState
        : ZIO[Any, AwsError, zio.aws.cloudhsmv2.model.BackupState] =
      AwsError.unwrapOptionField("backupState", backupState)
    def getClusterId: ZIO[Any, AwsError, ClusterId] =
      AwsError.unwrapOptionField("clusterId", clusterId)
    def getCreateTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createTimestamp", createTimestamp)
    def getCopyTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("copyTimestamp", copyTimestamp)
    def getNeverExpires: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("neverExpires", neverExpires)
    def getSourceRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("sourceRegion", sourceRegion)
    def getSourceBackup: ZIO[Any, AwsError, BackupId] =
      AwsError.unwrapOptionField("sourceBackup", sourceBackup)
    def getSourceCluster: ZIO[Any, AwsError, ClusterId] =
      AwsError.unwrapOptionField("sourceCluster", sourceCluster)
    def getDeleteTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deleteTimestamp", deleteTimestamp)
    def getTagList
        : ZIO[Any, AwsError, List[zio.aws.cloudhsmv2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.Backup
  ) extends zio.aws.cloudhsmv2.model.Backup.ReadOnly {
    override val backupId: BackupId =
      zio.aws.cloudhsmv2.model.primitives.BackupId(impl.backupId())
    override val backupState: Optional[zio.aws.cloudhsmv2.model.BackupState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupState())
        .map(value => zio.aws.cloudhsmv2.model.BackupState.wrap(value))
    override val clusterId: Optional[ClusterId] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterId())
      .map(value => zio.aws.cloudhsmv2.model.primitives.ClusterId(value))
    override val createTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createTimestamp())
      .map(value => zio.aws.cloudhsmv2.model.primitives.Timestamp(value))
    override val copyTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTimestamp())
      .map(value => zio.aws.cloudhsmv2.model.primitives.Timestamp(value))
    override val neverExpires: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.neverExpires())
      .map(value => value: Boolean)
    override val sourceRegion: Optional[Region] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceRegion())
      .map(value => zio.aws.cloudhsmv2.model.primitives.Region(value))
    override val sourceBackup: Optional[BackupId] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceBackup())
      .map(value => zio.aws.cloudhsmv2.model.primitives.BackupId(value))
    override val sourceCluster: Optional[ClusterId] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceCluster())
      .map(value => zio.aws.cloudhsmv2.model.primitives.ClusterId(value))
    override val deleteTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteTimestamp())
      .map(value => zio.aws.cloudhsmv2.model.primitives.Timestamp(value))
    override val tagList
        : Optional[List[zio.aws.cloudhsmv2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudhsmv2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.Backup
  ): zio.aws.cloudhsmv2.model.Backup.ReadOnly = new Wrapper(impl)
}
