package zio.aws.cloudhsmv2.model
import zio.aws.cloudhsmv2.model.primitives.ClusterId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModifyClusterRequest(
    backupRetentionPolicy: zio.aws.cloudhsmv2.model.BackupRetentionPolicy,
    clusterId: ClusterId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.ModifyClusterRequest = {
    import ModifyClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.ModifyClusterRequest
      .builder()
      .backupRetentionPolicy(backupRetentionPolicy.buildAwsValue())
      .clusterId(ClusterId.unwrap(clusterId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.ModifyClusterRequest.ReadOnly =
    zio.aws.cloudhsmv2.model.ModifyClusterRequest.wrap(buildAwsValue())
}
object ModifyClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.ModifyClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.ModifyClusterRequest =
      zio.aws.cloudhsmv2.model
        .ModifyClusterRequest(backupRetentionPolicy.asEditable, clusterId)
    def backupRetentionPolicy
        : zio.aws.cloudhsmv2.model.BackupRetentionPolicy.ReadOnly
    def clusterId: ClusterId
    def getBackupRetentionPolicy: ZIO[
      Any,
      Nothing,
      zio.aws.cloudhsmv2.model.BackupRetentionPolicy.ReadOnly
    ] = ZIO.succeed(backupRetentionPolicy)
    def getClusterId: ZIO[Any, Nothing, ClusterId] = ZIO.succeed(clusterId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.ModifyClusterRequest
  ) extends zio.aws.cloudhsmv2.model.ModifyClusterRequest.ReadOnly {
    override val backupRetentionPolicy
        : zio.aws.cloudhsmv2.model.BackupRetentionPolicy.ReadOnly =
      zio.aws.cloudhsmv2.model.BackupRetentionPolicy
        .wrap(impl.backupRetentionPolicy())
    override val clusterId: ClusterId =
      zio.aws.cloudhsmv2.model.primitives.ClusterId(impl.clusterId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.ModifyClusterRequest
  ): zio.aws.cloudhsmv2.model.ModifyClusterRequest.ReadOnly = new Wrapper(impl)
}
