package zio.aws.cloudhsmv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudhsmv2.model.primitives.{Field, BackupsMaxSize, NextToken}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeBackupsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[BackupsMaxSize] = Optional.Absent,
    filters: Optional[Map[Field, Iterable[String]]] = Optional.Absent,
    sortAscending: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsRequest = {
    import DescribeBackupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => BackupsMaxSize.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        filters.map(value =>
          value
            .map({ case (key, value) =>
              (Field.unwrap(key): java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.filters)
      .optionallyWith(sortAscending.map(value => value: java.lang.Boolean))(
        _.sortAscending
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.DescribeBackupsRequest.ReadOnly =
    zio.aws.cloudhsmv2.model.DescribeBackupsRequest.wrap(buildAwsValue())
}
object DescribeBackupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.DescribeBackupsRequest =
      zio.aws.cloudhsmv2.model.DescribeBackupsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        filters.map(value => value),
        sortAscending.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[BackupsMaxSize]
    def filters: Optional[Map[Field, List[String]]]
    def sortAscending: Optional[Boolean]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, BackupsMaxSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilters: ZIO[Any, AwsError, Map[Field, List[String]]] =
      AwsError.unwrapOptionField("filters", filters)
    def getSortAscending: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("sortAscending", sortAscending)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsRequest
  ) extends zio.aws.cloudhsmv2.model.DescribeBackupsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudhsmv2.model.primitives.NextToken(value))
    override val maxResults: Optional[BackupsMaxSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.cloudhsmv2.model.primitives.BackupsMaxSize(value))
    override val filters: Optional[Map[Field, List[String]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.cloudhsmv2.model.primitives
                .Field(key) -> value.asScala.map { item =>
                item: String
              }.toList
            })
            .toMap
        )
    override val sortAscending: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.sortAscending())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsRequest
  ): zio.aws.cloudhsmv2.model.DescribeBackupsRequest.ReadOnly = new Wrapper(
    impl
  )
}
