package zio.aws.cloudhsmv2.model
import zio.aws.cloudhsmv2.model.primitives.BackupRetentionValue
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BackupRetentionPolicy(
    `type`: Optional[zio.aws.cloudhsmv2.model.BackupRetentionType] =
      Optional.Absent,
    value: Optional[BackupRetentionValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.BackupRetentionPolicy = {
    import BackupRetentionPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.BackupRetentionPolicy
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        value.map(value => BackupRetentionValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.BackupRetentionPolicy.ReadOnly =
    zio.aws.cloudhsmv2.model.BackupRetentionPolicy.wrap(buildAwsValue())
}
object BackupRetentionPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.BackupRetentionPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.BackupRetentionPolicy =
      zio.aws.cloudhsmv2.model.BackupRetentionPolicy(
        `type`.map(value => value),
        value.map(value => value)
      )
    def `type`: Optional[zio.aws.cloudhsmv2.model.BackupRetentionType]
    def value: Optional[BackupRetentionValue]
    def getType
        : ZIO[Any, AwsError, zio.aws.cloudhsmv2.model.BackupRetentionType] =
      AwsError.unwrapOptionField("type", `type`)
    def getValue: ZIO[Any, AwsError, BackupRetentionValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.BackupRetentionPolicy
  ) extends zio.aws.cloudhsmv2.model.BackupRetentionPolicy.ReadOnly {
    override val `type`
        : Optional[zio.aws.cloudhsmv2.model.BackupRetentionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.cloudhsmv2.model.BackupRetentionType.wrap(value))
    override val value: Optional[BackupRetentionValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.cloudhsmv2.model.primitives.BackupRetentionValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.BackupRetentionPolicy
  ): zio.aws.cloudhsmv2.model.BackupRetentionPolicy.ReadOnly = new Wrapper(impl)
}
