package zio.aws.cloudhsmv2.model
import zio.aws.cloudhsmv2.model.primitives.{
  SubnetId,
  HsmId,
  IpAddress,
  ExternalAz,
  EniId,
  ClusterId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Hsm(
    availabilityZone: Optional[ExternalAz] = Optional.Absent,
    clusterId: Optional[ClusterId] = Optional.Absent,
    subnetId: Optional[SubnetId] = Optional.Absent,
    eniId: Optional[EniId] = Optional.Absent,
    eniIp: Optional[IpAddress] = Optional.Absent,
    hsmId: HsmId,
    state: Optional[zio.aws.cloudhsmv2.model.HsmState] = Optional.Absent,
    stateMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.cloudhsmv2.model.Hsm = {
    import Hsm.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.Hsm
      .builder()
      .optionallyWith(
        availabilityZone.map(value =>
          ExternalAz.unwrap(value): java.lang.String
        )
      )(_.availabilityZone)
      .optionallyWith(
        clusterId.map(value => ClusterId.unwrap(value): java.lang.String)
      )(_.clusterId)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        eniId.map(value => EniId.unwrap(value): java.lang.String)
      )(_.eniId)
      .optionallyWith(
        eniIp.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.eniIp)
      .hsmId(HsmId.unwrap(hsmId): java.lang.String)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateMessage.map(value => value: java.lang.String))(
        _.stateMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.Hsm.ReadOnly =
    zio.aws.cloudhsmv2.model.Hsm.wrap(buildAwsValue())
}
object Hsm {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.cloudhsmv2.model.Hsm] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.Hsm = zio.aws.cloudhsmv2.model.Hsm(
      availabilityZone.map(value => value),
      clusterId.map(value => value),
      subnetId.map(value => value),
      eniId.map(value => value),
      eniIp.map(value => value),
      hsmId,
      state.map(value => value),
      stateMessage.map(value => value)
    )
    def availabilityZone: Optional[ExternalAz]
    def clusterId: Optional[ClusterId]
    def subnetId: Optional[SubnetId]
    def eniId: Optional[EniId]
    def eniIp: Optional[IpAddress]
    def hsmId: HsmId
    def state: Optional[zio.aws.cloudhsmv2.model.HsmState]
    def stateMessage: Optional[String]
    def getAvailabilityZone: ZIO[Any, AwsError, ExternalAz] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getClusterId: ZIO[Any, AwsError, ClusterId] =
      AwsError.unwrapOptionField("clusterId", clusterId)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getEniId: ZIO[Any, AwsError, EniId] =
      AwsError.unwrapOptionField("eniId", eniId)
    def getEniIp: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("eniIp", eniIp)
    def getHsmId: ZIO[Any, Nothing, HsmId] = ZIO.succeed(hsmId)
    def getState: ZIO[Any, AwsError, zio.aws.cloudhsmv2.model.HsmState] =
      AwsError.unwrapOptionField("state", state)
    def getStateMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stateMessage", stateMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.Hsm
  ) extends zio.aws.cloudhsmv2.model.Hsm.ReadOnly {
    override val availabilityZone: Optional[ExternalAz] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => zio.aws.cloudhsmv2.model.primitives.ExternalAz(value))
    override val clusterId: Optional[ClusterId] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterId())
      .map(value => zio.aws.cloudhsmv2.model.primitives.ClusterId(value))
    override val subnetId: Optional[SubnetId] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.cloudhsmv2.model.primitives.SubnetId(value))
    override val eniId: Optional[EniId] = zio.aws.core.internal
      .optionalFromNullable(impl.eniId())
      .map(value => zio.aws.cloudhsmv2.model.primitives.EniId(value))
    override val eniIp: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.eniIp())
      .map(value => zio.aws.cloudhsmv2.model.primitives.IpAddress(value))
    override val hsmId: HsmId =
      zio.aws.cloudhsmv2.model.primitives.HsmId(impl.hsmId())
    override val state: Optional[zio.aws.cloudhsmv2.model.HsmState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.cloudhsmv2.model.HsmState.wrap(value))
    override val stateMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stateMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.Hsm
  ): zio.aws.cloudhsmv2.model.Hsm.ReadOnly = new Wrapper(impl)
}
