package zio.aws.cloudhsmv2.model
import zio.aws.cloudhsmv2.model.primitives.HsmId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteHsmResponse(hsmId: Option[HsmId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.DeleteHsmResponse = {
    import DeleteHsmResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.DeleteHsmResponse
      .builder()
      .optionallyWith(
        hsmId.map(value => HsmId.unwrap(value): java.lang.String)
      )(_.hsmId)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.DeleteHsmResponse.ReadOnly =
    zio.aws.cloudhsmv2.model.DeleteHsmResponse.wrap(buildAwsValue())
}
object DeleteHsmResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.DeleteHsmResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.DeleteHsmResponse =
      zio.aws.cloudhsmv2.model.DeleteHsmResponse(hsmId.map(value => value))
    def hsmId: Option[HsmId]
    def getHsmId: ZIO[Any, AwsError, HsmId] =
      AwsError.unwrapOptionField("hsmId", hsmId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.DeleteHsmResponse
  ) extends zio.aws.cloudhsmv2.model.DeleteHsmResponse.ReadOnly {
    override val hsmId: Option[HsmId] = scala
      .Option(impl.hsmId())
      .map(value => zio.aws.cloudhsmv2.model.primitives.HsmId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.DeleteHsmResponse
  ): zio.aws.cloudhsmv2.model.DeleteHsmResponse.ReadOnly = new Wrapper(impl)
}
