package zio.aws.cloudhsmv2.model
import zio.aws.cloudhsmv2.model.primitives.{SubnetId, BackupId, HsmType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateClusterRequest(
    backupRetentionPolicy: Option[
      zio.aws.cloudhsmv2.model.BackupRetentionPolicy
    ] = None,
    hsmType: HsmType,
    sourceBackupId: Option[BackupId] = None,
    subnetIds: Iterable[SubnetId],
    tagList: Option[Iterable[zio.aws.cloudhsmv2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.CreateClusterRequest = {
    import CreateClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.CreateClusterRequest
      .builder()
      .optionallyWith(
        backupRetentionPolicy.map(value => value.buildAwsValue())
      )(_.backupRetentionPolicy)
      .hsmType(HsmType.unwrap(hsmType): java.lang.String)
      .optionallyWith(
        sourceBackupId.map(value => BackupId.unwrap(value): java.lang.String)
      )(_.sourceBackupId)
      .subnetIds(subnetIds.map { item =>
        SubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.CreateClusterRequest.ReadOnly =
    zio.aws.cloudhsmv2.model.CreateClusterRequest.wrap(buildAwsValue())
}
object CreateClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.CreateClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.CreateClusterRequest =
      zio.aws.cloudhsmv2.model.CreateClusterRequest(
        backupRetentionPolicy.map(value => value.asEditable),
        hsmType,
        sourceBackupId.map(value => value),
        subnetIds,
        tagList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def backupRetentionPolicy
        : Option[zio.aws.cloudhsmv2.model.BackupRetentionPolicy.ReadOnly]
    def hsmType: HsmType
    def sourceBackupId: Option[BackupId]
    def subnetIds: List[SubnetId]
    def tagList: Option[List[zio.aws.cloudhsmv2.model.Tag.ReadOnly]]
    def getBackupRetentionPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.cloudhsmv2.model.BackupRetentionPolicy.ReadOnly
    ] =
      AwsError.unwrapOptionField("backupRetentionPolicy", backupRetentionPolicy)
    def getHsmType: ZIO[Any, Nothing, HsmType] = ZIO.succeed(hsmType)
    def getSourceBackupId: ZIO[Any, AwsError, BackupId] =
      AwsError.unwrapOptionField("sourceBackupId", sourceBackupId)
    def getSubnetIds: ZIO[Any, Nothing, List[SubnetId]] = ZIO.succeed(subnetIds)
    def getTagList
        : ZIO[Any, AwsError, List[zio.aws.cloudhsmv2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.CreateClusterRequest
  ) extends zio.aws.cloudhsmv2.model.CreateClusterRequest.ReadOnly {
    override val backupRetentionPolicy
        : Option[zio.aws.cloudhsmv2.model.BackupRetentionPolicy.ReadOnly] =
      scala
        .Option(impl.backupRetentionPolicy())
        .map(value =>
          zio.aws.cloudhsmv2.model.BackupRetentionPolicy.wrap(value)
        )
    override val hsmType: HsmType =
      zio.aws.cloudhsmv2.model.primitives.HsmType(impl.hsmType())
    override val sourceBackupId: Option[BackupId] = scala
      .Option(impl.sourceBackupId())
      .map(value => zio.aws.cloudhsmv2.model.primitives.BackupId(value))
    override val subnetIds: List[SubnetId] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.cloudhsmv2.model.primitives.SubnetId(item)
      }
      .toList
    override val tagList: Option[List[zio.aws.cloudhsmv2.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tagList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudhsmv2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.CreateClusterRequest
  ): zio.aws.cloudhsmv2.model.CreateClusterRequest.ReadOnly = new Wrapper(impl)
}
