package zio.aws.cloudhsmv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyClusterResponse(
    cluster: Option[zio.aws.cloudhsmv2.model.Cluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.ModifyClusterResponse = {
    import ModifyClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.ModifyClusterResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.ModifyClusterResponse.ReadOnly =
    zio.aws.cloudhsmv2.model.ModifyClusterResponse.wrap(buildAwsValue())
}
object ModifyClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.ModifyClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.ModifyClusterResponse =
      zio.aws.cloudhsmv2.model
        .ModifyClusterResponse(cluster.map(value => value.asEditable))
    def cluster: Option[zio.aws.cloudhsmv2.model.Cluster.ReadOnly]
    def getCluster
        : ZIO[Any, AwsError, zio.aws.cloudhsmv2.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.ModifyClusterResponse
  ) extends zio.aws.cloudhsmv2.model.ModifyClusterResponse.ReadOnly {
    override val cluster: Option[zio.aws.cloudhsmv2.model.Cluster.ReadOnly] =
      scala
        .Option(impl.cluster())
        .map(value => zio.aws.cloudhsmv2.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.ModifyClusterResponse
  ): zio.aws.cloudhsmv2.model.ModifyClusterResponse.ReadOnly = new Wrapper(impl)
}
