package zio.aws.cloudhsmv2.model
import scala.jdk.CollectionConverters._
sealed trait ClusterState {
  def unwrap: software.amazon.awssdk.services.cloudhsmv2.model.ClusterState
}
object ClusterState {
  def wrap(
      value: software.amazon.awssdk.services.cloudhsmv2.model.ClusterState
  ): zio.aws.cloudhsmv2.model.ClusterState = value match {
    case software.amazon.awssdk.services.cloudhsmv2.model.ClusterState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudhsmv2.model.ClusterState.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudhsmv2.model.ClusterState.UNINITIALIZED =>
      val r = UNINITIALIZED
      r
    case software.amazon.awssdk.services.cloudhsmv2.model.ClusterState.INITIALIZE_IN_PROGRESS =>
      val r = INITIALIZE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudhsmv2.model.ClusterState.INITIALIZED =>
      val r = INITIALIZED
      r
    case software.amazon.awssdk.services.cloudhsmv2.model.ClusterState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.cloudhsmv2.model.ClusterState.UPDATE_IN_PROGRESS =>
      val r = UPDATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudhsmv2.model.ClusterState.DELETE_IN_PROGRESS =>
      val r = DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudhsmv2.model.ClusterState.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.cloudhsmv2.model.ClusterState.DEGRADED =>
      val r = DEGRADED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudhsmv2.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsmv2.model.ClusterState =
      software.amazon.awssdk.services.cloudhsmv2.model.ClusterState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_IN_PROGRESS extends zio.aws.cloudhsmv2.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsmv2.model.ClusterState =
      software.amazon.awssdk.services.cloudhsmv2.model.ClusterState.CREATE_IN_PROGRESS
  }
  case object UNINITIALIZED extends zio.aws.cloudhsmv2.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsmv2.model.ClusterState =
      software.amazon.awssdk.services.cloudhsmv2.model.ClusterState.UNINITIALIZED
  }
  case object INITIALIZE_IN_PROGRESS
      extends zio.aws.cloudhsmv2.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsmv2.model.ClusterState =
      software.amazon.awssdk.services.cloudhsmv2.model.ClusterState.INITIALIZE_IN_PROGRESS
  }
  case object INITIALIZED extends zio.aws.cloudhsmv2.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsmv2.model.ClusterState =
      software.amazon.awssdk.services.cloudhsmv2.model.ClusterState.INITIALIZED
  }
  case object ACTIVE extends zio.aws.cloudhsmv2.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsmv2.model.ClusterState =
      software.amazon.awssdk.services.cloudhsmv2.model.ClusterState.ACTIVE
  }
  case object UPDATE_IN_PROGRESS extends zio.aws.cloudhsmv2.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsmv2.model.ClusterState =
      software.amazon.awssdk.services.cloudhsmv2.model.ClusterState.UPDATE_IN_PROGRESS
  }
  case object DELETE_IN_PROGRESS extends zio.aws.cloudhsmv2.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsmv2.model.ClusterState =
      software.amazon.awssdk.services.cloudhsmv2.model.ClusterState.DELETE_IN_PROGRESS
  }
  case object DELETED extends zio.aws.cloudhsmv2.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsmv2.model.ClusterState =
      software.amazon.awssdk.services.cloudhsmv2.model.ClusterState.DELETED
  }
  case object DEGRADED extends zio.aws.cloudhsmv2.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsmv2.model.ClusterState =
      software.amazon.awssdk.services.cloudhsmv2.model.ClusterState.DEGRADED
  }
}
