package zio.aws.cloudhsmv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RestoreBackupResponse(
    backup: Option[zio.aws.cloudhsmv2.model.Backup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.RestoreBackupResponse = {
    import RestoreBackupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.RestoreBackupResponse
      .builder()
      .optionallyWith(backup.map(value => value.buildAwsValue()))(_.backup)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.RestoreBackupResponse.ReadOnly =
    zio.aws.cloudhsmv2.model.RestoreBackupResponse.wrap(buildAwsValue())
}
object RestoreBackupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.RestoreBackupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.RestoreBackupResponse =
      zio.aws.cloudhsmv2.model
        .RestoreBackupResponse(backup.map(value => value.asEditable))
    def backup: Option[zio.aws.cloudhsmv2.model.Backup.ReadOnly]
    def getBackup
        : ZIO[Any, AwsError, zio.aws.cloudhsmv2.model.Backup.ReadOnly] =
      AwsError.unwrapOptionField("backup", backup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.RestoreBackupResponse
  ) extends zio.aws.cloudhsmv2.model.RestoreBackupResponse.ReadOnly {
    override val backup: Option[zio.aws.cloudhsmv2.model.Backup.ReadOnly] =
      scala
        .Option(impl.backup())
        .map(value => zio.aws.cloudhsmv2.model.Backup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.RestoreBackupResponse
  ): zio.aws.cloudhsmv2.model.RestoreBackupResponse.ReadOnly = new Wrapper(impl)
}
