package zio.aws.cloudhsmv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateClusterResponse(
    cluster: Option[zio.aws.cloudhsmv2.model.Cluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.CreateClusterResponse = {
    import CreateClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.CreateClusterResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.CreateClusterResponse.ReadOnly =
    zio.aws.cloudhsmv2.model.CreateClusterResponse.wrap(buildAwsValue())
}
object CreateClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.CreateClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.CreateClusterResponse =
      zio.aws.cloudhsmv2.model
        .CreateClusterResponse(cluster.map(value => value.asEditable))
    def cluster: Option[zio.aws.cloudhsmv2.model.Cluster.ReadOnly]
    def getCluster
        : ZIO[Any, AwsError, zio.aws.cloudhsmv2.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.CreateClusterResponse
  ) extends zio.aws.cloudhsmv2.model.CreateClusterResponse.ReadOnly {
    override val cluster: Option[zio.aws.cloudhsmv2.model.Cluster.ReadOnly] =
      scala
        .Option(impl.cluster())
        .map(value => zio.aws.cloudhsmv2.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.CreateClusterResponse
  ): zio.aws.cloudhsmv2.model.CreateClusterResponse.ReadOnly = new Wrapper(impl)
}
