package zio.aws.cloudhsmv2.model
import zio.aws.cloudhsmv2.model.primitives.ClusterId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteClusterRequest(clusterId: ClusterId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.DeleteClusterRequest = {
    import DeleteClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.DeleteClusterRequest
      .builder()
      .clusterId(ClusterId.unwrap(clusterId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.DeleteClusterRequest.ReadOnly =
    zio.aws.cloudhsmv2.model.DeleteClusterRequest.wrap(buildAwsValue())
}
object DeleteClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.DeleteClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.DeleteClusterRequest =
      zio.aws.cloudhsmv2.model.DeleteClusterRequest(clusterId)
    def clusterId: ClusterId
    def getClusterId: ZIO[Any, Nothing, ClusterId] = ZIO.succeed(clusterId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.DeleteClusterRequest
  ) extends zio.aws.cloudhsmv2.model.DeleteClusterRequest.ReadOnly {
    override val clusterId: ClusterId =
      zio.aws.cloudhsmv2.model.primitives.ClusterId(impl.clusterId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.DeleteClusterRequest
  ): zio.aws.cloudhsmv2.model.DeleteClusterRequest.ReadOnly = new Wrapper(impl)
}
