package zio.aws.cloudhsmv2
import zio.aws.cloudhsmv2.model.CreateHsmResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.cloudhsmv2.CloudHsmV2AsyncClient
import zio.aws.cloudhsmv2.model.{
  ModifyBackupAttributesRequest,
  ListTagsRequest,
  CreateClusterRequest,
  CopyBackupToRegionRequest,
  DeleteClusterRequest,
  DeleteHsmRequest,
  DeleteBackupRequest,
  UntagResourceRequest,
  CreateHsmRequest,
  RestoreBackupRequest,
  ModifyClusterRequest,
  DescribeBackupsRequest,
  InitializeClusterRequest,
  DescribeClustersRequest,
  TagResourceRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object CloudHsmV2Mock extends Mock[CloudHsmV2] {
  object DescribeClusters
      extends Stream[
        DescribeClustersRequest,
        AwsError,
        zio.aws.cloudhsmv2.model.Cluster.ReadOnly
      ]
  object DescribeClustersPaginated
      extends Effect[
        DescribeClustersRequest,
        AwsError,
        zio.aws.cloudhsmv2.model.DescribeClustersResponse.ReadOnly
      ]
  object ModifyBackupAttributes
      extends Effect[
        ModifyBackupAttributesRequest,
        AwsError,
        zio.aws.cloudhsmv2.model.ModifyBackupAttributesResponse.ReadOnly
      ]
  object ListTags
      extends Stream[
        ListTagsRequest,
        AwsError,
        zio.aws.cloudhsmv2.model.Tag.ReadOnly
      ]
  object ListTagsPaginated
      extends Effect[
        ListTagsRequest,
        AwsError,
        zio.aws.cloudhsmv2.model.ListTagsResponse.ReadOnly
      ]
  object DescribeBackups
      extends Stream[
        DescribeBackupsRequest,
        AwsError,
        zio.aws.cloudhsmv2.model.Backup.ReadOnly
      ]
  object DescribeBackupsPaginated
      extends Effect[
        DescribeBackupsRequest,
        AwsError,
        zio.aws.cloudhsmv2.model.DescribeBackupsResponse.ReadOnly
      ]
  object CreateCluster
      extends Effect[
        CreateClusterRequest,
        AwsError,
        zio.aws.cloudhsmv2.model.CreateClusterResponse.ReadOnly
      ]
  object DeleteCluster
      extends Effect[
        DeleteClusterRequest,
        AwsError,
        zio.aws.cloudhsmv2.model.DeleteClusterResponse.ReadOnly
      ]
  object CreateHsm extends Effect[CreateHsmRequest, AwsError, ReadOnly]
  object InitializeCluster
      extends Effect[
        InitializeClusterRequest,
        AwsError,
        zio.aws.cloudhsmv2.model.InitializeClusterResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.cloudhsmv2.model.UntagResourceResponse.ReadOnly
      ]
  object DeleteHsm
      extends Effect[
        DeleteHsmRequest,
        AwsError,
        zio.aws.cloudhsmv2.model.DeleteHsmResponse.ReadOnly
      ]
  object ModifyCluster
      extends Effect[
        ModifyClusterRequest,
        AwsError,
        zio.aws.cloudhsmv2.model.ModifyClusterResponse.ReadOnly
      ]
  object DeleteBackup
      extends Effect[
        DeleteBackupRequest,
        AwsError,
        zio.aws.cloudhsmv2.model.DeleteBackupResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.cloudhsmv2.model.TagResourceResponse.ReadOnly
      ]
  object CopyBackupToRegion
      extends Effect[
        CopyBackupToRegionRequest,
        AwsError,
        zio.aws.cloudhsmv2.model.CopyBackupToRegionResponse.ReadOnly
      ]
  object RestoreBackup
      extends Effect[
        RestoreBackupRequest,
        AwsError,
        zio.aws.cloudhsmv2.model.RestoreBackupResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, CloudHsmV2] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new CloudHsmV2 {
          val api: CloudHsmV2AsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : CloudHsmV2 = this
          def describeClusters(
              request: DescribeClustersRequest
          ): ZStream[Any, AwsError, zio.aws.cloudhsmv2.model.Cluster.ReadOnly] =
            rts.unsafeRun(proxy(DescribeClusters, request))
          def describeClustersPaginated(request: DescribeClustersRequest): IO[
            AwsError,
            zio.aws.cloudhsmv2.model.DescribeClustersResponse.ReadOnly
          ] = proxy(DescribeClustersPaginated, request)
          def modifyBackupAttributes(
              request: ModifyBackupAttributesRequest
          ): IO[
            AwsError,
            zio.aws.cloudhsmv2.model.ModifyBackupAttributesResponse.ReadOnly
          ] = proxy(ModifyBackupAttributes, request)
          def listTags(
              request: ListTagsRequest
          ): ZStream[Any, AwsError, zio.aws.cloudhsmv2.model.Tag.ReadOnly] =
            rts.unsafeRun(proxy(ListTags, request))
          def listTagsPaginated(
              request: ListTagsRequest
          ): IO[AwsError, zio.aws.cloudhsmv2.model.ListTagsResponse.ReadOnly] =
            proxy(ListTagsPaginated, request)
          def describeBackups(
              request: DescribeBackupsRequest
          ): ZStream[Any, AwsError, zio.aws.cloudhsmv2.model.Backup.ReadOnly] =
            rts.unsafeRun(proxy(DescribeBackups, request))
          def describeBackupsPaginated(request: DescribeBackupsRequest): IO[
            AwsError,
            zio.aws.cloudhsmv2.model.DescribeBackupsResponse.ReadOnly
          ] = proxy(DescribeBackupsPaginated, request)
          def createCluster(request: CreateClusterRequest): IO[
            AwsError,
            zio.aws.cloudhsmv2.model.CreateClusterResponse.ReadOnly
          ] = proxy(CreateCluster, request)
          def deleteCluster(request: DeleteClusterRequest): IO[
            AwsError,
            zio.aws.cloudhsmv2.model.DeleteClusterResponse.ReadOnly
          ] = proxy(DeleteCluster, request)
          def createHsm(request: CreateHsmRequest): IO[AwsError, ReadOnly] =
            proxy(CreateHsm, request)
          def initializeCluster(request: InitializeClusterRequest): IO[
            AwsError,
            zio.aws.cloudhsmv2.model.InitializeClusterResponse.ReadOnly
          ] = proxy(InitializeCluster, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.cloudhsmv2.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def deleteHsm(
              request: DeleteHsmRequest
          ): IO[AwsError, zio.aws.cloudhsmv2.model.DeleteHsmResponse.ReadOnly] =
            proxy(DeleteHsm, request)
          def modifyCluster(request: ModifyClusterRequest): IO[
            AwsError,
            zio.aws.cloudhsmv2.model.ModifyClusterResponse.ReadOnly
          ] = proxy(ModifyCluster, request)
          def deleteBackup(request: DeleteBackupRequest): IO[
            AwsError,
            zio.aws.cloudhsmv2.model.DeleteBackupResponse.ReadOnly
          ] = proxy(DeleteBackup, request)
          def tagResource(request: TagResourceRequest): IO[
            AwsError,
            zio.aws.cloudhsmv2.model.TagResourceResponse.ReadOnly
          ] = proxy(TagResource, request)
          def copyBackupToRegion(request: CopyBackupToRegionRequest): IO[
            AwsError,
            zio.aws.cloudhsmv2.model.CopyBackupToRegionResponse.ReadOnly
          ] = proxy(CopyBackupToRegion, request)
          def restoreBackup(request: RestoreBackupRequest): IO[
            AwsError,
            zio.aws.cloudhsmv2.model.RestoreBackupResponse.ReadOnly
          ] = proxy(RestoreBackup, request)
        }
      }
    }
    .toLayer
}
