package zio.aws.cloudhsmv2
import zio.aws.cloudhsmv2.model.CreateHsmResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.cloudhsmv2.{
  CloudHsmV2AsyncClientBuilder,
  CloudHsmV2AsyncClient
}
import zio.aws.cloudhsmv2.model.{
  ModifyBackupAttributesRequest,
  ListTagsRequest,
  CreateClusterRequest,
  CopyBackupToRegionRequest,
  DeleteClusterRequest,
  DeleteHsmRequest,
  DeleteBackupRequest,
  UntagResourceRequest,
  CreateHsmRequest,
  RestoreBackupRequest,
  ModifyClusterRequest,
  DescribeBackupsRequest,
  InitializeClusterRequest,
  DescribeClustersRequest,
  TagResourceRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.cloudhsmv2.model.{
  InitializeClusterResponse,
  Cluster,
  Backup,
  DeleteHsmResponse,
  Tag,
  CreateHsmResponse,
  RestoreBackupResponse,
  UntagResourceResponse,
  ModifyBackupAttributesResponse,
  DescribeBackupsResponse,
  CreateClusterResponse,
  DescribeClustersResponse,
  CopyBackupToRegionResponse,
  DeleteClusterResponse,
  DeleteBackupResponse,
  TagResourceResponse,
  ModifyClusterResponse,
  ListTagsResponse
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait CloudHsmV2 extends AspectSupport[CloudHsmV2] {
  val api: CloudHsmV2AsyncClient
  def describeClusters(
      request: DescribeClustersRequest
  ): ZStream[Any, AwsError, zio.aws.cloudhsmv2.model.Cluster.ReadOnly]
  def describeClustersPaginated(
      request: DescribeClustersRequest
  ): IO[AwsError, zio.aws.cloudhsmv2.model.DescribeClustersResponse.ReadOnly]
  def modifyBackupAttributes(request: ModifyBackupAttributesRequest): IO[
    AwsError,
    zio.aws.cloudhsmv2.model.ModifyBackupAttributesResponse.ReadOnly
  ]
  def listTags(
      request: ListTagsRequest
  ): ZStream[Any, AwsError, zio.aws.cloudhsmv2.model.Tag.ReadOnly]
  def listTagsPaginated(
      request: ListTagsRequest
  ): IO[AwsError, zio.aws.cloudhsmv2.model.ListTagsResponse.ReadOnly]
  def describeBackups(
      request: DescribeBackupsRequest
  ): ZStream[Any, AwsError, zio.aws.cloudhsmv2.model.Backup.ReadOnly]
  def describeBackupsPaginated(
      request: DescribeBackupsRequest
  ): IO[AwsError, zio.aws.cloudhsmv2.model.DescribeBackupsResponse.ReadOnly]
  def createCluster(
      request: CreateClusterRequest
  ): IO[AwsError, zio.aws.cloudhsmv2.model.CreateClusterResponse.ReadOnly]
  def deleteCluster(
      request: DeleteClusterRequest
  ): IO[AwsError, zio.aws.cloudhsmv2.model.DeleteClusterResponse.ReadOnly]
  def createHsm(request: CreateHsmRequest): IO[AwsError, ReadOnly]
  def initializeCluster(
      request: InitializeClusterRequest
  ): IO[AwsError, zio.aws.cloudhsmv2.model.InitializeClusterResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.cloudhsmv2.model.UntagResourceResponse.ReadOnly]
  def deleteHsm(
      request: DeleteHsmRequest
  ): IO[AwsError, zio.aws.cloudhsmv2.model.DeleteHsmResponse.ReadOnly]
  def modifyCluster(
      request: ModifyClusterRequest
  ): IO[AwsError, zio.aws.cloudhsmv2.model.ModifyClusterResponse.ReadOnly]
  def deleteBackup(
      request: DeleteBackupRequest
  ): IO[AwsError, zio.aws.cloudhsmv2.model.DeleteBackupResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.cloudhsmv2.model.TagResourceResponse.ReadOnly]
  def copyBackupToRegion(
      request: CopyBackupToRegionRequest
  ): IO[AwsError, zio.aws.cloudhsmv2.model.CopyBackupToRegionResponse.ReadOnly]
  def restoreBackup(
      request: RestoreBackupRequest
  ): IO[AwsError, zio.aws.cloudhsmv2.model.RestoreBackupResponse.ReadOnly]
}
object CloudHsmV2 {
  val live: ZLayer[AwsConfig, java.lang.Throwable, CloudHsmV2] = customized(
    identity
  )
  def customized(
      customization: CloudHsmV2AsyncClientBuilder => CloudHsmV2AsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, CloudHsmV2] = managed(
    customization
  ).toLayer
  def managed(
      customization: CloudHsmV2AsyncClientBuilder => CloudHsmV2AsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, CloudHsmV2] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = CloudHsmV2AsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[CloudHsmV2AsyncClient, CloudHsmV2AsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[CloudHsmV2AsyncClient, CloudHsmV2AsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new CloudHsmV2Impl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class CloudHsmV2Impl[R](
      override val api: CloudHsmV2AsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends CloudHsmV2
      with AwsServiceBase[R] {
    override val serviceName: String = "CloudHsmV2"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): CloudHsmV2Impl[R1] = new CloudHsmV2Impl(api, newAspect, r)
    def describeClusters(request: DescribeClustersRequest): ZStream[
      Any,
      AwsError,
      zio.aws.cloudhsmv2.model.Cluster.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersRequest,
      DescribeClustersResponse,
      Cluster
    ](
      "describeClusters",
      api.describeClusters,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.clusters().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.cloudhsmv2.model.Cluster.wrap(item))
      .provideEnvironment(r)
    def describeClustersPaginated(request: DescribeClustersRequest): IO[
      AwsError,
      zio.aws.cloudhsmv2.model.DescribeClustersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersRequest,
      DescribeClustersResponse
    ]("describeClusters", api.describeClusters)(request.buildAwsValue())
      .map(zio.aws.cloudhsmv2.model.DescribeClustersResponse.wrap)
      .provideEnvironment(r)
    def modifyBackupAttributes(request: ModifyBackupAttributesRequest): IO[
      AwsError,
      zio.aws.cloudhsmv2.model.ModifyBackupAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudhsmv2.model.ModifyBackupAttributesRequest,
      ModifyBackupAttributesResponse
    ]("modifyBackupAttributes", api.modifyBackupAttributes)(
      request.buildAwsValue()
    ).map(zio.aws.cloudhsmv2.model.ModifyBackupAttributesResponse.wrap)
      .provideEnvironment(r)
    def listTags(
        request: ListTagsRequest
    ): ZStream[Any, AwsError, zio.aws.cloudhsmv2.model.Tag.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.cloudhsmv2.model.ListTagsRequest,
        ListTagsResponse,
        Tag
      ](
        "listTags",
        api.listTags,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.tagList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.cloudhsmv2.model.Tag.wrap(item))
        .provideEnvironment(r)
    def listTagsPaginated(
        request: ListTagsRequest
    ): IO[AwsError, zio.aws.cloudhsmv2.model.ListTagsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsmv2.model.ListTagsRequest,
        ListTagsResponse
      ]("listTags", api.listTags)(request.buildAwsValue())
        .map(zio.aws.cloudhsmv2.model.ListTagsResponse.wrap)
        .provideEnvironment(r)
    def describeBackups(
        request: DescribeBackupsRequest
    ): ZStream[Any, AwsError, zio.aws.cloudhsmv2.model.Backup.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsRequest,
        DescribeBackupsResponse,
        Backup
      ](
        "describeBackups",
        api.describeBackups,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.backups().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.cloudhsmv2.model.Backup.wrap(item))
        .provideEnvironment(r)
    def describeBackupsPaginated(
        request: DescribeBackupsRequest
    ): IO[AwsError, zio.aws.cloudhsmv2.model.DescribeBackupsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsRequest,
        DescribeBackupsResponse
      ]("describeBackups", api.describeBackups)(request.buildAwsValue())
        .map(zio.aws.cloudhsmv2.model.DescribeBackupsResponse.wrap)
        .provideEnvironment(r)
    def createCluster(
        request: CreateClusterRequest
    ): IO[AwsError, zio.aws.cloudhsmv2.model.CreateClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsmv2.model.CreateClusterRequest,
        CreateClusterResponse
      ]("createCluster", api.createCluster)(request.buildAwsValue())
        .map(zio.aws.cloudhsmv2.model.CreateClusterResponse.wrap)
        .provideEnvironment(r)
    def deleteCluster(
        request: DeleteClusterRequest
    ): IO[AwsError, zio.aws.cloudhsmv2.model.DeleteClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsmv2.model.DeleteClusterRequest,
        DeleteClusterResponse
      ]("deleteCluster", api.deleteCluster)(request.buildAwsValue())
        .map(zio.aws.cloudhsmv2.model.DeleteClusterResponse.wrap)
        .provideEnvironment(r)
    def createHsm(request: CreateHsmRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsmv2.model.CreateHsmRequest,
        CreateHsmResponse
      ]("createHsm", api.createHsm)(request.buildAwsValue())
        .map(zio.aws.cloudhsmv2.model.CreateHsmResponse.wrap)
        .provideEnvironment(r)
    def initializeCluster(request: InitializeClusterRequest): IO[
      AwsError,
      zio.aws.cloudhsmv2.model.InitializeClusterResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudhsmv2.model.InitializeClusterRequest,
      InitializeClusterResponse
    ]("initializeCluster", api.initializeCluster)(request.buildAwsValue())
      .map(zio.aws.cloudhsmv2.model.InitializeClusterResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.cloudhsmv2.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsmv2.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.cloudhsmv2.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def deleteHsm(
        request: DeleteHsmRequest
    ): IO[AwsError, zio.aws.cloudhsmv2.model.DeleteHsmResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsmv2.model.DeleteHsmRequest,
        DeleteHsmResponse
      ]("deleteHsm", api.deleteHsm)(request.buildAwsValue())
        .map(zio.aws.cloudhsmv2.model.DeleteHsmResponse.wrap)
        .provideEnvironment(r)
    def modifyCluster(
        request: ModifyClusterRequest
    ): IO[AwsError, zio.aws.cloudhsmv2.model.ModifyClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsmv2.model.ModifyClusterRequest,
        ModifyClusterResponse
      ]("modifyCluster", api.modifyCluster)(request.buildAwsValue())
        .map(zio.aws.cloudhsmv2.model.ModifyClusterResponse.wrap)
        .provideEnvironment(r)
    def deleteBackup(
        request: DeleteBackupRequest
    ): IO[AwsError, zio.aws.cloudhsmv2.model.DeleteBackupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsmv2.model.DeleteBackupRequest,
        DeleteBackupResponse
      ]("deleteBackup", api.deleteBackup)(request.buildAwsValue())
        .map(zio.aws.cloudhsmv2.model.DeleteBackupResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.cloudhsmv2.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsmv2.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.cloudhsmv2.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def copyBackupToRegion(request: CopyBackupToRegionRequest): IO[
      AwsError,
      zio.aws.cloudhsmv2.model.CopyBackupToRegionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudhsmv2.model.CopyBackupToRegionRequest,
      CopyBackupToRegionResponse
    ]("copyBackupToRegion", api.copyBackupToRegion)(request.buildAwsValue())
      .map(zio.aws.cloudhsmv2.model.CopyBackupToRegionResponse.wrap)
      .provideEnvironment(r)
    def restoreBackup(
        request: RestoreBackupRequest
    ): IO[AwsError, zio.aws.cloudhsmv2.model.RestoreBackupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsmv2.model.RestoreBackupRequest,
        RestoreBackupResponse
      ]("restoreBackup", api.restoreBackup)(request.buildAwsValue())
        .map(zio.aws.cloudhsmv2.model.RestoreBackupResponse.wrap)
        .provideEnvironment(r)
  }
  def describeClusters(request: DescribeClustersRequest): ZStream[
    zio.aws.cloudhsmv2.CloudHsmV2,
    AwsError,
    zio.aws.cloudhsmv2.model.Cluster.ReadOnly
  ] = ZStream.serviceWithStream(_.describeClusters(request))
  def describeClustersPaginated(request: DescribeClustersRequest): ZIO[
    zio.aws.cloudhsmv2.CloudHsmV2,
    AwsError,
    zio.aws.cloudhsmv2.model.DescribeClustersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeClustersPaginated(request))
  def modifyBackupAttributes(request: ModifyBackupAttributesRequest): ZIO[
    zio.aws.cloudhsmv2.CloudHsmV2,
    AwsError,
    zio.aws.cloudhsmv2.model.ModifyBackupAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyBackupAttributes(request))
  def listTags(request: ListTagsRequest): ZStream[
    zio.aws.cloudhsmv2.CloudHsmV2,
    AwsError,
    zio.aws.cloudhsmv2.model.Tag.ReadOnly
  ] = ZStream.serviceWithStream(_.listTags(request))
  def listTagsPaginated(request: ListTagsRequest): ZIO[
    zio.aws.cloudhsmv2.CloudHsmV2,
    AwsError,
    zio.aws.cloudhsmv2.model.ListTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsPaginated(request))
  def describeBackups(request: DescribeBackupsRequest): ZStream[
    zio.aws.cloudhsmv2.CloudHsmV2,
    AwsError,
    zio.aws.cloudhsmv2.model.Backup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeBackups(request))
  def describeBackupsPaginated(request: DescribeBackupsRequest): ZIO[
    zio.aws.cloudhsmv2.CloudHsmV2,
    AwsError,
    zio.aws.cloudhsmv2.model.DescribeBackupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeBackupsPaginated(request))
  def createCluster(request: CreateClusterRequest): ZIO[
    zio.aws.cloudhsmv2.CloudHsmV2,
    AwsError,
    zio.aws.cloudhsmv2.model.CreateClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCluster(request))
  def deleteCluster(request: DeleteClusterRequest): ZIO[
    zio.aws.cloudhsmv2.CloudHsmV2,
    AwsError,
    zio.aws.cloudhsmv2.model.DeleteClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCluster(request))
  def createHsm(
      request: CreateHsmRequest
  ): ZIO[zio.aws.cloudhsmv2.CloudHsmV2, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.createHsm(request))
  def initializeCluster(request: InitializeClusterRequest): ZIO[
    zio.aws.cloudhsmv2.CloudHsmV2,
    AwsError,
    zio.aws.cloudhsmv2.model.InitializeClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.initializeCluster(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.cloudhsmv2.CloudHsmV2,
    AwsError,
    zio.aws.cloudhsmv2.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def deleteHsm(request: DeleteHsmRequest): ZIO[
    zio.aws.cloudhsmv2.CloudHsmV2,
    AwsError,
    zio.aws.cloudhsmv2.model.DeleteHsmResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteHsm(request))
  def modifyCluster(request: ModifyClusterRequest): ZIO[
    zio.aws.cloudhsmv2.CloudHsmV2,
    AwsError,
    zio.aws.cloudhsmv2.model.ModifyClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyCluster(request))
  def deleteBackup(request: DeleteBackupRequest): ZIO[
    zio.aws.cloudhsmv2.CloudHsmV2,
    AwsError,
    zio.aws.cloudhsmv2.model.DeleteBackupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBackup(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.cloudhsmv2.CloudHsmV2,
    AwsError,
    zio.aws.cloudhsmv2.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def copyBackupToRegion(request: CopyBackupToRegionRequest): ZIO[
    zio.aws.cloudhsmv2.CloudHsmV2,
    AwsError,
    zio.aws.cloudhsmv2.model.CopyBackupToRegionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copyBackupToRegion(request))
  def restoreBackup(request: RestoreBackupRequest): ZIO[
    zio.aws.cloudhsmv2.CloudHsmV2,
    AwsError,
    zio.aws.cloudhsmv2.model.RestoreBackupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreBackup(request))
}
