package zio.aws.cloudhsmv2.model
import zio.aws.cloudhsmv2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeClustersResponse(
    clusters: Option[Iterable[zio.aws.cloudhsmv2.model.Cluster]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersResponse = {
    import DescribeClustersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersResponse
      .builder()
      .optionallyWith(
        clusters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.DescribeClustersResponse.ReadOnly =
    zio.aws.cloudhsmv2.model.DescribeClustersResponse.wrap(buildAwsValue())
}
object DescribeClustersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.DescribeClustersResponse =
      zio.aws.cloudhsmv2.model.DescribeClustersResponse(
        clusters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def clusters: Option[List[zio.aws.cloudhsmv2.model.Cluster.ReadOnly]]
    def nextToken: Option[NextToken]
    def getClusters
        : ZIO[Any, AwsError, List[zio.aws.cloudhsmv2.model.Cluster.ReadOnly]] =
      AwsError.unwrapOptionField("clusters", clusters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersResponse
  ) extends zio.aws.cloudhsmv2.model.DescribeClustersResponse.ReadOnly {
    override val clusters
        : Option[List[zio.aws.cloudhsmv2.model.Cluster.ReadOnly]] = scala
      .Option(impl.clusters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudhsmv2.model.Cluster.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudhsmv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersResponse
  ): zio.aws.cloudhsmv2.model.DescribeClustersResponse.ReadOnly = new Wrapper(
    impl
  )
}
