package zio.aws.cloudhsmv2.model
import zio.aws.cloudhsmv2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTagsResponse(
    tagList: Iterable[zio.aws.cloudhsmv2.model.Tag],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.ListTagsResponse = {
    import ListTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.ListTagsResponse
      .builder()
      .tagList(tagList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.ListTagsResponse.ReadOnly =
    zio.aws.cloudhsmv2.model.ListTagsResponse.wrap(buildAwsValue())
}
object ListTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.ListTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.ListTagsResponse =
      zio.aws.cloudhsmv2.model.ListTagsResponse(
        tagList.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def tagList: List[zio.aws.cloudhsmv2.model.Tag.ReadOnly]
    def nextToken: Option[NextToken]
    def getTagList
        : ZIO[Any, Nothing, List[zio.aws.cloudhsmv2.model.Tag.ReadOnly]] =
      ZIO.succeed(tagList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.ListTagsResponse
  ) extends zio.aws.cloudhsmv2.model.ListTagsResponse.ReadOnly {
    override val tagList: List[zio.aws.cloudhsmv2.model.Tag.ReadOnly] = impl
      .tagList()
      .asScala
      .map { item =>
        zio.aws.cloudhsmv2.model.Tag.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudhsmv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.ListTagsResponse
  ): zio.aws.cloudhsmv2.model.ListTagsResponse.ReadOnly = new Wrapper(impl)
}
