package zio.aws.cloudhsmv2.model
import java.lang.Integer
import zio.aws.cloudhsmv2.model.primitives.{Field, BackupsMaxSize, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeBackupsRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[BackupsMaxSize] = None,
    filters: Option[Map[Field, Iterable[String]]] = None,
    sortAscending: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsRequest = {
    import DescribeBackupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => BackupsMaxSize.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        filters.map(value =>
          value
            .map({ case (key, value) =>
              (Field.unwrap(key): java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.filters)
      .optionallyWith(sortAscending.map(value => value: java.lang.Boolean))(
        _.sortAscending
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.DescribeBackupsRequest.ReadOnly =
    zio.aws.cloudhsmv2.model.DescribeBackupsRequest.wrap(buildAwsValue())
}
object DescribeBackupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.DescribeBackupsRequest =
      zio.aws.cloudhsmv2.model.DescribeBackupsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        filters.map(value => value),
        sortAscending.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[BackupsMaxSize]
    def filters: Option[Map[Field, List[String]]]
    def sortAscending: Option[Boolean]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, BackupsMaxSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilters: ZIO[Any, AwsError, Map[Field, List[String]]] =
      AwsError.unwrapOptionField("filters", filters)
    def getSortAscending: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("sortAscending", sortAscending)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsRequest
  ) extends zio.aws.cloudhsmv2.model.DescribeBackupsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudhsmv2.model.primitives.NextToken(value))
    override val maxResults: Option[BackupsMaxSize] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.cloudhsmv2.model.primitives.BackupsMaxSize(value))
    override val filters: Option[Map[Field, List[String]]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.cloudhsmv2.model.primitives
              .Field(key) -> value.asScala.map { item =>
              item: String
            }.toList
          })
          .toMap
      )
    override val sortAscending: Option[Boolean] =
      scala.Option(impl.sortAscending()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsRequest
  ): zio.aws.cloudhsmv2.model.DescribeBackupsRequest.ReadOnly = new Wrapper(
    impl
  )
}
