package zio.aws.cloudhsmv2.model
import java.lang.Integer
import zio.aws.cloudhsmv2.model.primitives.{MaxSize, NextToken, ResourceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTagsRequest(
    resourceId: ResourceId,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.ListTagsRequest = {
    import ListTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.ListTagsRequest
      .builder()
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => MaxSize.unwrap(value): Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.ListTagsRequest.ReadOnly =
    zio.aws.cloudhsmv2.model.ListTagsRequest.wrap(buildAwsValue())
}
object ListTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.ListTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.ListTagsRequest =
      zio.aws.cloudhsmv2.model.ListTagsRequest(
        resourceId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def resourceId: ResourceId
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxSize]
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.ListTagsRequest
  ) extends zio.aws.cloudhsmv2.model.ListTagsRequest.ReadOnly {
    override val resourceId: ResourceId =
      zio.aws.cloudhsmv2.model.primitives.ResourceId(impl.resourceId())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudhsmv2.model.primitives.NextToken(value))
    override val maxResults: Option[MaxSize] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.cloudhsmv2.model.primitives.MaxSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.ListTagsRequest
  ): zio.aws.cloudhsmv2.model.ListTagsRequest.ReadOnly = new Wrapper(impl)
}
