package zio.aws.cloudhsmv2.model
import zio.aws.cloudhsmv2.model.primitives.StateMessage
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InitializeClusterResponse(
    state: Option[zio.aws.cloudhsmv2.model.ClusterState] = None,
    stateMessage: Option[StateMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.InitializeClusterResponse = {
    import InitializeClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.InitializeClusterResponse
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        stateMessage.map(value => StateMessage.unwrap(value): java.lang.String)
      )(_.stateMessage)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.InitializeClusterResponse.ReadOnly =
    zio.aws.cloudhsmv2.model.InitializeClusterResponse.wrap(buildAwsValue())
}
object InitializeClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.InitializeClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.InitializeClusterResponse =
      zio.aws.cloudhsmv2.model.InitializeClusterResponse(
        state.map(value => value),
        stateMessage.map(value => value)
      )
    def state: Option[zio.aws.cloudhsmv2.model.ClusterState]
    def stateMessage: Option[StateMessage]
    def getState: ZIO[Any, AwsError, zio.aws.cloudhsmv2.model.ClusterState] =
      AwsError.unwrapOptionField("state", state)
    def getStateMessage: ZIO[Any, AwsError, StateMessage] =
      AwsError.unwrapOptionField("stateMessage", stateMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.InitializeClusterResponse
  ) extends zio.aws.cloudhsmv2.model.InitializeClusterResponse.ReadOnly {
    override val state: Option[zio.aws.cloudhsmv2.model.ClusterState] = scala
      .Option(impl.state())
      .map(value => zio.aws.cloudhsmv2.model.ClusterState.wrap(value))
    override val stateMessage: Option[StateMessage] = scala
      .Option(impl.stateMessage())
      .map(value => zio.aws.cloudhsmv2.model.primitives.StateMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.InitializeClusterResponse
  ): zio.aws.cloudhsmv2.model.InitializeClusterResponse.ReadOnly = new Wrapper(
    impl
  )
}
