package zio.aws.cloudhsmv2.model
import zio.aws.cloudhsmv2.model.primitives.Cert
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Certificates(
    clusterCsr: Option[Cert] = None,
    hsmCertificate: Option[Cert] = None,
    awsHardwareCertificate: Option[Cert] = None,
    manufacturerHardwareCertificate: Option[Cert] = None,
    clusterCertificate: Option[Cert] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.Certificates = {
    import Certificates.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.Certificates
      .builder()
      .optionallyWith(
        clusterCsr.map(value => Cert.unwrap(value): java.lang.String)
      )(_.clusterCsr)
      .optionallyWith(
        hsmCertificate.map(value => Cert.unwrap(value): java.lang.String)
      )(_.hsmCertificate)
      .optionallyWith(
        awsHardwareCertificate.map(value =>
          Cert.unwrap(value): java.lang.String
        )
      )(_.awsHardwareCertificate)
      .optionallyWith(
        manufacturerHardwareCertificate.map(value =>
          Cert.unwrap(value): java.lang.String
        )
      )(_.manufacturerHardwareCertificate)
      .optionallyWith(
        clusterCertificate.map(value => Cert.unwrap(value): java.lang.String)
      )(_.clusterCertificate)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.Certificates.ReadOnly =
    zio.aws.cloudhsmv2.model.Certificates.wrap(buildAwsValue())
}
object Certificates {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.Certificates
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.Certificates =
      zio.aws.cloudhsmv2.model.Certificates(
        clusterCsr.map(value => value),
        hsmCertificate.map(value => value),
        awsHardwareCertificate.map(value => value),
        manufacturerHardwareCertificate.map(value => value),
        clusterCertificate.map(value => value)
      )
    def clusterCsr: Option[Cert]
    def hsmCertificate: Option[Cert]
    def awsHardwareCertificate: Option[Cert]
    def manufacturerHardwareCertificate: Option[Cert]
    def clusterCertificate: Option[Cert]
    def getClusterCsr: ZIO[Any, AwsError, Cert] =
      AwsError.unwrapOptionField("clusterCsr", clusterCsr)
    def getHsmCertificate: ZIO[Any, AwsError, Cert] =
      AwsError.unwrapOptionField("hsmCertificate", hsmCertificate)
    def getAwsHardwareCertificate: ZIO[Any, AwsError, Cert] = AwsError
      .unwrapOptionField("awsHardwareCertificate", awsHardwareCertificate)
    def getManufacturerHardwareCertificate: ZIO[Any, AwsError, Cert] =
      AwsError.unwrapOptionField(
        "manufacturerHardwareCertificate",
        manufacturerHardwareCertificate
      )
    def getClusterCertificate: ZIO[Any, AwsError, Cert] =
      AwsError.unwrapOptionField("clusterCertificate", clusterCertificate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.Certificates
  ) extends zio.aws.cloudhsmv2.model.Certificates.ReadOnly {
    override val clusterCsr: Option[Cert] = scala
      .Option(impl.clusterCsr())
      .map(value => zio.aws.cloudhsmv2.model.primitives.Cert(value))
    override val hsmCertificate: Option[Cert] = scala
      .Option(impl.hsmCertificate())
      .map(value => zio.aws.cloudhsmv2.model.primitives.Cert(value))
    override val awsHardwareCertificate: Option[Cert] = scala
      .Option(impl.awsHardwareCertificate())
      .map(value => zio.aws.cloudhsmv2.model.primitives.Cert(value))
    override val manufacturerHardwareCertificate: Option[Cert] = scala
      .Option(impl.manufacturerHardwareCertificate())
      .map(value => zio.aws.cloudhsmv2.model.primitives.Cert(value))
    override val clusterCertificate: Option[Cert] = scala
      .Option(impl.clusterCertificate())
      .map(value => zio.aws.cloudhsmv2.model.primitives.Cert(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.Certificates
  ): zio.aws.cloudhsmv2.model.Certificates.ReadOnly = new Wrapper(impl)
}
